// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The type of the action that will be triggered by the Automation. </summary>
    internal readonly partial struct ActionType : IEquatable<ActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LogicAppValue = "LogicApp";
        private const string EventHubValue = "EventHub";
        private const string WorkspaceValue = "Workspace";

        /// <summary> LogicApp. </summary>
        public static ActionType LogicApp { get; } = new ActionType(LogicAppValue);
        /// <summary> EventHub. </summary>
        public static ActionType EventHub { get; } = new ActionType(EventHubValue);
        /// <summary> Workspace. </summary>
        public static ActionType Workspace { get; } = new ActionType(WorkspaceValue);
        /// <summary> Determines if two <see cref="ActionType"/> values are the same. </summary>
        public static bool operator ==(ActionType left, ActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ActionType"/> values are not the same. </summary>
        public static bool operator !=(ActionType left, ActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ActionType"/>. </summary>
        public static implicit operator ActionType(string value) => new ActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
