// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The external security solution properties for AAD solutions. </summary>
    public partial class AadSolutionProperties : ExternalSecuritySolutionProperties
    {
        /// <summary> Initializes a new instance of <see cref="AadSolutionProperties"/>. </summary>
        public AadSolutionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AadSolutionProperties"/>. </summary>
        /// <param name="deviceVendor"></param>
        /// <param name="deviceType"></param>
        /// <param name="workspace"> Represents an OMS workspace to which the solution is connected. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="connectivityState"> The connectivity state of the external AAD solution. </param>
        internal AadSolutionProperties(string deviceVendor, string deviceType, WritableSubResource workspace, IDictionary<string, BinaryData> additionalProperties, AadConnectivityStateType? connectivityState) : base(deviceVendor, deviceType, workspace, additionalProperties)
        {
            ConnectivityState = connectivityState;
        }

        /// <summary> The connectivity state of the external AAD solution. </summary>
        public AadConnectivityStateType? ConnectivityState { get; set; }
    }
}
