// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter
{
    internal class SecurityCenterApiCollectionOperationSource : IOperationSource<SecurityCenterApiCollectionResource>
    {
        private readonly ArmClient _client;

        internal SecurityCenterApiCollectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        SecurityCenterApiCollectionResource IOperationSource<SecurityCenterApiCollectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SecurityCenterApiCollectionData.DeserializeSecurityCenterApiCollectionData(document.RootElement);
            return new SecurityCenterApiCollectionResource(_client, data);
        }

        async ValueTask<SecurityCenterApiCollectionResource> IOperationSource<SecurityCenterApiCollectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SecurityCenterApiCollectionData.DeserializeSecurityCenterApiCollectionData(document.RootElement);
            return new SecurityCenterApiCollectionResource(_client, data);
        }
    }
}
