// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter
{
    internal class DevOpsRepositoryOperationSource : IOperationSource<DevOpsRepositoryResource>
    {
        private readonly ArmClient _client;

        internal DevOpsRepositoryOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevOpsRepositoryResource IOperationSource<DevOpsRepositoryResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevOpsRepositoryData.DeserializeDevOpsRepositoryData(document.RootElement);
            return new DevOpsRepositoryResource(_client, data);
        }

        async ValueTask<DevOpsRepositoryResource> IOperationSource<DevOpsRepositoryResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevOpsRepositoryData.DeserializeDevOpsRepositoryData(document.RootElement);
            return new DevOpsRepositoryResource(_client, data);
        }
    }
}
