// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter
{
    internal class DevOpsProjectOperationSource : IOperationSource<DevOpsProjectResource>
    {
        private readonly ArmClient _client;

        internal DevOpsProjectOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevOpsProjectResource IOperationSource<DevOpsProjectResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevOpsProjectData.DeserializeDevOpsProjectData(document.RootElement);
            return new DevOpsProjectResource(_client, data);
        }

        async ValueTask<DevOpsProjectResource> IOperationSource<DevOpsProjectResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevOpsProjectData.DeserializeDevOpsProjectData(document.RootElement);
            return new DevOpsProjectResource(_client, data);
        }
    }
}
