// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter
{
    internal class DevOpsOrgOperationSource : IOperationSource<DevOpsOrgResource>
    {
        private readonly ArmClient _client;

        internal DevOpsOrgOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevOpsOrgResource IOperationSource<DevOpsOrgResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevOpsOrgData.DeserializeDevOpsOrgData(document.RootElement);
            return new DevOpsOrgResource(_client, data);
        }

        async ValueTask<DevOpsOrgResource> IOperationSource<DevOpsOrgResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevOpsOrgData.DeserializeDevOpsOrgData(document.RootElement);
            return new DevOpsOrgResource(_client, data);
        }
    }
}
