// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter
{
    internal class DevOpsConfigurationOperationSource : IOperationSource<DevOpsConfigurationResource>
    {
        private readonly ArmClient _client;

        internal DevOpsConfigurationOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevOpsConfigurationResource IOperationSource<DevOpsConfigurationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevOpsConfigurationData.DeserializeDevOpsConfigurationData(document.RootElement);
            return new DevOpsConfigurationResource(_client, data);
        }

        async ValueTask<DevOpsConfigurationResource> IOperationSource<DevOpsConfigurationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevOpsConfigurationData.DeserializeDevOpsConfigurationData(document.RootElement);
            return new DevOpsConfigurationResource(_client, data);
        }
    }
}
