// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing the IotSecurityAggregatedAlert data model.
    /// Security Solution Aggregated Alert information
    /// </summary>
    public partial class IotSecurityAggregatedAlertData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotSecurityAggregatedAlertData"/>. </summary>
        public IotSecurityAggregatedAlertData()
        {
            TopDevicesList = new ChangeTrackingList<IotSecurityAggregatedAlertTopDevice>();
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="IotSecurityAggregatedAlertData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="alertType"> Name of the alert type. </param>
        /// <param name="alertDisplayName"> Display name of the alert type. </param>
        /// <param name="aggregatedOn"> Date of detection. </param>
        /// <param name="vendorName"> Name of the organization that raised the alert. </param>
        /// <param name="reportedSeverity"> Assessed alert severity. </param>
        /// <param name="remediationSteps"> Recommended steps for remediation. </param>
        /// <param name="description"> Description of the suspected vulnerability and meaning. </param>
        /// <param name="count"> Number of alerts occurrences within the aggregated time window. </param>
        /// <param name="effectedResourceType"> Azure resource ID of the resource that received the alerts. </param>
        /// <param name="systemSource"> The type of the alerted resource (Azure, Non-Azure). </param>
        /// <param name="actionTaken"> IoT Security solution alert response. </param>
        /// <param name="logAnalyticsQuery"> Log analytics query for getting the list of affected devices/alerts. </param>
        /// <param name="topDevicesList"> 10 devices with the highest number of occurrences of this alert type, on this day. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotSecurityAggregatedAlertData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string alertType, string alertDisplayName, DateTimeOffset? aggregatedOn, string vendorName, ReportedSeverity? reportedSeverity, string remediationSteps, string description, long? count, string effectedResourceType, string systemSource, string actionTaken, string logAnalyticsQuery, IReadOnlyList<IotSecurityAggregatedAlertTopDevice> topDevicesList, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            AlertType = alertType;
            AlertDisplayName = alertDisplayName;
            AggregatedOn = aggregatedOn;
            VendorName = vendorName;
            ReportedSeverity = reportedSeverity;
            RemediationSteps = remediationSteps;
            Description = description;
            Count = count;
            EffectedResourceType = effectedResourceType;
            SystemSource = systemSource;
            ActionTaken = actionTaken;
            LogAnalyticsQuery = logAnalyticsQuery;
            TopDevicesList = topDevicesList;
            Tags = tags;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the alert type. </summary>
        public string AlertType { get; }
        /// <summary> Display name of the alert type. </summary>
        public string AlertDisplayName { get; }
        /// <summary> Date of detection. </summary>
        public DateTimeOffset? AggregatedOn { get; }
        /// <summary> Name of the organization that raised the alert. </summary>
        public string VendorName { get; }
        /// <summary> Assessed alert severity. </summary>
        public ReportedSeverity? ReportedSeverity { get; }
        /// <summary> Recommended steps for remediation. </summary>
        public string RemediationSteps { get; }
        /// <summary> Description of the suspected vulnerability and meaning. </summary>
        public string Description { get; }
        /// <summary> Number of alerts occurrences within the aggregated time window. </summary>
        public long? Count { get; }
        /// <summary> Azure resource ID of the resource that received the alerts. </summary>
        public string EffectedResourceType { get; }
        /// <summary> The type of the alerted resource (Azure, Non-Azure). </summary>
        public string SystemSource { get; }
        /// <summary> IoT Security solution alert response. </summary>
        public string ActionTaken { get; }
        /// <summary> Log analytics query for getting the list of affected devices/alerts. </summary>
        public string LogAnalyticsQuery { get; }
        /// <summary> 10 devices with the highest number of occurrences of this alert type, on this day. </summary>
        public IReadOnlyList<IotSecurityAggregatedAlertTopDevice> TopDevicesList { get; }
        /// <summary> Resource tags. </summary>
        public IDictionary<string, string> Tags { get; }
    }
}
