// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    public partial class IotSecurityAggregatedAlertData : IUtf8JsonSerializable, IJsonModel<IotSecurityAggregatedAlertData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IotSecurityAggregatedAlertData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IotSecurityAggregatedAlertData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotSecurityAggregatedAlertData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IotSecurityAggregatedAlertData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(AlertType))
            {
                writer.WritePropertyName("alertType"u8);
                writer.WriteStringValue(AlertType);
            }
            if (options.Format != "W" && Optional.IsDefined(AlertDisplayName))
            {
                writer.WritePropertyName("alertDisplayName"u8);
                writer.WriteStringValue(AlertDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(AggregatedOn))
            {
                writer.WritePropertyName("aggregatedDateUtc"u8);
                writer.WriteStringValue(AggregatedOn.Value, "D");
            }
            if (options.Format != "W" && Optional.IsDefined(VendorName))
            {
                writer.WritePropertyName("vendorName"u8);
                writer.WriteStringValue(VendorName);
            }
            if (options.Format != "W" && Optional.IsDefined(ReportedSeverity))
            {
                writer.WritePropertyName("reportedSeverity"u8);
                writer.WriteStringValue(ReportedSeverity.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RemediationSteps))
            {
                writer.WritePropertyName("remediationSteps"u8);
                writer.WriteStringValue(RemediationSteps);
            }
            if (options.Format != "W" && Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && Optional.IsDefined(Count))
            {
                writer.WritePropertyName("count"u8);
                writer.WriteNumberValue(Count.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(EffectedResourceType))
            {
                writer.WritePropertyName("effectedResourceType"u8);
                writer.WriteStringValue(EffectedResourceType);
            }
            if (options.Format != "W" && Optional.IsDefined(SystemSource))
            {
                writer.WritePropertyName("systemSource"u8);
                writer.WriteStringValue(SystemSource);
            }
            if (options.Format != "W" && Optional.IsDefined(ActionTaken))
            {
                writer.WritePropertyName("actionTaken"u8);
                writer.WriteStringValue(ActionTaken);
            }
            if (options.Format != "W" && Optional.IsDefined(LogAnalyticsQuery))
            {
                writer.WritePropertyName("logAnalyticsQuery"u8);
                writer.WriteStringValue(LogAnalyticsQuery);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(TopDevicesList))
            {
                writer.WritePropertyName("topDevicesList"u8);
                writer.WriteStartArray();
                foreach (var item in TopDevicesList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        IotSecurityAggregatedAlertData IJsonModel<IotSecurityAggregatedAlertData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotSecurityAggregatedAlertData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IotSecurityAggregatedAlertData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIotSecurityAggregatedAlertData(document.RootElement, options);
        }

        internal static IotSecurityAggregatedAlertData DeserializeIotSecurityAggregatedAlertData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string alertType = default;
            string alertDisplayName = default;
            DateTimeOffset? aggregatedDateUtc = default;
            string vendorName = default;
            ReportedSeverity? reportedSeverity = default;
            string remediationSteps = default;
            string description = default;
            long? count = default;
            string effectedResourceType = default;
            string systemSource = default;
            string actionTaken = default;
            string logAnalyticsQuery = default;
            IReadOnlyList<IotSecurityAggregatedAlertTopDevice> topDevicesList = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("alertType"u8))
                        {
                            alertType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("alertDisplayName"u8))
                        {
                            alertDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("aggregatedDateUtc"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            aggregatedDateUtc = property0.Value.GetDateTimeOffset("D");
                            continue;
                        }
                        if (property0.NameEquals("vendorName"u8))
                        {
                            vendorName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("reportedSeverity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            reportedSeverity = new ReportedSeverity(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("remediationSteps"u8))
                        {
                            remediationSteps = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("count"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            count = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("effectedResourceType"u8))
                        {
                            effectedResourceType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("systemSource"u8))
                        {
                            systemSource = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("actionTaken"u8))
                        {
                            actionTaken = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("logAnalyticsQuery"u8))
                        {
                            logAnalyticsQuery = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("topDevicesList"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<IotSecurityAggregatedAlertTopDevice> array = new List<IotSecurityAggregatedAlertTopDevice>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(IotSecurityAggregatedAlertTopDevice.DeserializeIotSecurityAggregatedAlertTopDevice(item, options));
                            }
                            topDevicesList = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IotSecurityAggregatedAlertData(
                id,
                name,
                type,
                systemData,
                alertType,
                alertDisplayName,
                aggregatedDateUtc,
                vendorName,
                reportedSeverity,
                remediationSteps,
                description,
                count,
                effectedResourceType,
                systemSource,
                actionTaken,
                logAnalyticsQuery,
                topDevicesList ?? new ChangeTrackingList<IotSecurityAggregatedAlertTopDevice>(),
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<IotSecurityAggregatedAlertData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotSecurityAggregatedAlertData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(IotSecurityAggregatedAlertData)} does not support writing '{options.Format}' format.");
            }
        }

        IotSecurityAggregatedAlertData IPersistableModel<IotSecurityAggregatedAlertData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotSecurityAggregatedAlertData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIotSecurityAggregatedAlertData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IotSecurityAggregatedAlertData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IotSecurityAggregatedAlertData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
