// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="GovernanceAssignmentResource"/> and their operations.
    /// Each <see cref="GovernanceAssignmentResource"/> in the collection will belong to the same instance of <see cref="SecurityAssessmentResource"/>.
    /// To get a <see cref="GovernanceAssignmentCollection"/> instance call the GetGovernanceAssignments method from an instance of <see cref="SecurityAssessmentResource"/>.
    /// </summary>
    public partial class GovernanceAssignmentCollection : ArmCollection, IEnumerable<GovernanceAssignmentResource>, IAsyncEnumerable<GovernanceAssignmentResource>
    {
        private readonly ClientDiagnostics _governanceAssignmentClientDiagnostics;
        private readonly GovernanceAssignmentsRestOperations _governanceAssignmentRestClient;

        /// <summary> Initializes a new instance of the <see cref="GovernanceAssignmentCollection"/> class for mocking. </summary>
        protected GovernanceAssignmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="GovernanceAssignmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal GovernanceAssignmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _governanceAssignmentClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", GovernanceAssignmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(GovernanceAssignmentResource.ResourceType, out string governanceAssignmentApiVersion);
            _governanceAssignmentRestClient = new GovernanceAssignmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, governanceAssignmentApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SecurityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SecurityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a governance assignment on the given subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assignmentKey"> The governance assignment key - the assessment key of the required governance assignment. </param>
        /// <param name="data"> Governance assignment over a subscription scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentKey"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentKey"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<GovernanceAssignmentResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string assignmentKey, GovernanceAssignmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentKey, nameof(assignmentKey));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _governanceAssignmentClientDiagnostics.CreateScope("GovernanceAssignmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _governanceAssignmentRestClient.CreateOrUpdateAsync(Id.Parent, Id.Name, assignmentKey, data, cancellationToken).ConfigureAwait(false);
                var uri = _governanceAssignmentRestClient.CreateCreateOrUpdateRequestUri(Id.Parent, Id.Name, assignmentKey, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<GovernanceAssignmentResource>(Response.FromValue(new GovernanceAssignmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a governance assignment on the given subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assignmentKey"> The governance assignment key - the assessment key of the required governance assignment. </param>
        /// <param name="data"> Governance assignment over a subscription scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentKey"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentKey"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<GovernanceAssignmentResource> CreateOrUpdate(WaitUntil waitUntil, string assignmentKey, GovernanceAssignmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentKey, nameof(assignmentKey));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _governanceAssignmentClientDiagnostics.CreateScope("GovernanceAssignmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _governanceAssignmentRestClient.CreateOrUpdate(Id.Parent, Id.Name, assignmentKey, data, cancellationToken);
                var uri = _governanceAssignmentRestClient.CreateCreateOrUpdateRequestUri(Id.Parent, Id.Name, assignmentKey, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<GovernanceAssignmentResource>(Response.FromValue(new GovernanceAssignmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a specific governanceAssignment for the requested scope by AssignmentKey
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentKey"> The governance assignment key - the assessment key of the required governance assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentKey"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentKey"/> is null. </exception>
        public virtual async Task<Response<GovernanceAssignmentResource>> GetAsync(string assignmentKey, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentKey, nameof(assignmentKey));

            using var scope = _governanceAssignmentClientDiagnostics.CreateScope("GovernanceAssignmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _governanceAssignmentRestClient.GetAsync(Id.Parent, Id.Name, assignmentKey, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new GovernanceAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a specific governanceAssignment for the requested scope by AssignmentKey
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentKey"> The governance assignment key - the assessment key of the required governance assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentKey"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentKey"/> is null. </exception>
        public virtual Response<GovernanceAssignmentResource> Get(string assignmentKey, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentKey, nameof(assignmentKey));

            using var scope = _governanceAssignmentClientDiagnostics.CreateScope("GovernanceAssignmentCollection.Get");
            scope.Start();
            try
            {
                var response = _governanceAssignmentRestClient.Get(Id.Parent, Id.Name, assignmentKey, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new GovernanceAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get governance assignments on all of your resources inside a scope
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="GovernanceAssignmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<GovernanceAssignmentResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _governanceAssignmentRestClient.CreateListRequest(Id.Parent, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _governanceAssignmentRestClient.CreateListNextPageRequest(nextLink, Id.Parent, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new GovernanceAssignmentResource(Client, GovernanceAssignmentData.DeserializeGovernanceAssignmentData(e)), _governanceAssignmentClientDiagnostics, Pipeline, "GovernanceAssignmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get governance assignments on all of your resources inside a scope
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="GovernanceAssignmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<GovernanceAssignmentResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _governanceAssignmentRestClient.CreateListRequest(Id.Parent, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _governanceAssignmentRestClient.CreateListNextPageRequest(nextLink, Id.Parent, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new GovernanceAssignmentResource(Client, GovernanceAssignmentData.DeserializeGovernanceAssignmentData(e)), _governanceAssignmentClientDiagnostics, Pipeline, "GovernanceAssignmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentKey"> The governance assignment key - the assessment key of the required governance assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentKey"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentKey"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string assignmentKey, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentKey, nameof(assignmentKey));

            using var scope = _governanceAssignmentClientDiagnostics.CreateScope("GovernanceAssignmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _governanceAssignmentRestClient.GetAsync(Id.Parent, Id.Name, assignmentKey, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentKey"> The governance assignment key - the assessment key of the required governance assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentKey"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentKey"/> is null. </exception>
        public virtual Response<bool> Exists(string assignmentKey, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentKey, nameof(assignmentKey));

            using var scope = _governanceAssignmentClientDiagnostics.CreateScope("GovernanceAssignmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _governanceAssignmentRestClient.Get(Id.Parent, Id.Name, assignmentKey, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentKey"> The governance assignment key - the assessment key of the required governance assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentKey"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentKey"/> is null. </exception>
        public virtual async Task<NullableResponse<GovernanceAssignmentResource>> GetIfExistsAsync(string assignmentKey, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentKey, nameof(assignmentKey));

            using var scope = _governanceAssignmentClientDiagnostics.CreateScope("GovernanceAssignmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _governanceAssignmentRestClient.GetAsync(Id.Parent, Id.Name, assignmentKey, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<GovernanceAssignmentResource>(response.GetRawResponse());
                return Response.FromValue(new GovernanceAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GovernanceAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="GovernanceAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentKey"> The governance assignment key - the assessment key of the required governance assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentKey"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentKey"/> is null. </exception>
        public virtual NullableResponse<GovernanceAssignmentResource> GetIfExists(string assignmentKey, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentKey, nameof(assignmentKey));

            using var scope = _governanceAssignmentClientDiagnostics.CreateScope("GovernanceAssignmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _governanceAssignmentRestClient.Get(Id.Parent, Id.Name, assignmentKey, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<GovernanceAssignmentResource>(response.GetRawResponse());
                return Response.FromValue(new GovernanceAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<GovernanceAssignmentResource> IEnumerable<GovernanceAssignmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<GovernanceAssignmentResource> IAsyncEnumerable<GovernanceAssignmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
