// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="DevOpsOrgResource"/> and their operations.
    /// Each <see cref="DevOpsOrgResource"/> in the collection will belong to the same instance of <see cref="DevOpsConfigurationResource"/>.
    /// To get a <see cref="DevOpsOrgCollection"/> instance call the GetDevOpsOrgs method from an instance of <see cref="DevOpsConfigurationResource"/>.
    /// </summary>
    public partial class DevOpsOrgCollection : ArmCollection, IEnumerable<DevOpsOrgResource>, IAsyncEnumerable<DevOpsOrgResource>
    {
        private readonly ClientDiagnostics _devOpsOrgAzureDevOpsOrgsClientDiagnostics;
        private readonly AzureDevOpsOrgsRestOperations _devOpsOrgAzureDevOpsOrgsRestClient;

        /// <summary> Initializes a new instance of the <see cref="DevOpsOrgCollection"/> class for mocking. </summary>
        protected DevOpsOrgCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DevOpsOrgCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DevOpsOrgCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _devOpsOrgAzureDevOpsOrgsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", DevOpsOrgResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DevOpsOrgResource.ResourceType, out string devOpsOrgAzureDevOpsOrgsApiVersion);
            _devOpsOrgAzureDevOpsOrgsRestClient = new AzureDevOpsOrgsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, devOpsOrgAzureDevOpsOrgsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != DevOpsConfigurationResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, DevOpsConfigurationResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates monitored Azure DevOps organization details.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="orgName"> The Azure DevOps organization name. </param>
        /// <param name="data"> The Azure DevOps organization resource payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="orgName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="orgName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DevOpsOrgResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string orgName, DevOpsOrgData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(orgName, nameof(orgName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _devOpsOrgAzureDevOpsOrgsClientDiagnostics.CreateScope("DevOpsOrgCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _devOpsOrgAzureDevOpsOrgsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, data, cancellationToken).ConfigureAwait(false);
                var operation = new SecurityCenterArmOperation<DevOpsOrgResource>(new DevOpsOrgOperationSource(Client), _devOpsOrgAzureDevOpsOrgsClientDiagnostics, Pipeline, _devOpsOrgAzureDevOpsOrgsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates monitored Azure DevOps organization details.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="orgName"> The Azure DevOps organization name. </param>
        /// <param name="data"> The Azure DevOps organization resource payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="orgName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="orgName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DevOpsOrgResource> CreateOrUpdate(WaitUntil waitUntil, string orgName, DevOpsOrgData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(orgName, nameof(orgName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _devOpsOrgAzureDevOpsOrgsClientDiagnostics.CreateScope("DevOpsOrgCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _devOpsOrgAzureDevOpsOrgsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, data, cancellationToken);
                var operation = new SecurityCenterArmOperation<DevOpsOrgResource>(new DevOpsOrgOperationSource(Client), _devOpsOrgAzureDevOpsOrgsClientDiagnostics, Pipeline, _devOpsOrgAzureDevOpsOrgsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a monitored Azure DevOps organization resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orgName"> The Azure DevOps organization name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="orgName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="orgName"/> is null. </exception>
        public virtual async Task<Response<DevOpsOrgResource>> GetAsync(string orgName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(orgName, nameof(orgName));

            using var scope = _devOpsOrgAzureDevOpsOrgsClientDiagnostics.CreateScope("DevOpsOrgCollection.Get");
            scope.Start();
            try
            {
                var response = await _devOpsOrgAzureDevOpsOrgsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DevOpsOrgResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a monitored Azure DevOps organization resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orgName"> The Azure DevOps organization name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="orgName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="orgName"/> is null. </exception>
        public virtual Response<DevOpsOrgResource> Get(string orgName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(orgName, nameof(orgName));

            using var scope = _devOpsOrgAzureDevOpsOrgsClientDiagnostics.CreateScope("DevOpsOrgCollection.Get");
            scope.Start();
            try
            {
                var response = _devOpsOrgAzureDevOpsOrgsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DevOpsOrgResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a list of Azure DevOps organizations onboarded to the connector.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DevOpsOrgResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DevOpsOrgResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _devOpsOrgAzureDevOpsOrgsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _devOpsOrgAzureDevOpsOrgsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DevOpsOrgResource(Client, DevOpsOrgData.DeserializeDevOpsOrgData(e)), _devOpsOrgAzureDevOpsOrgsClientDiagnostics, Pipeline, "DevOpsOrgCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns a list of Azure DevOps organizations onboarded to the connector.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DevOpsOrgResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DevOpsOrgResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _devOpsOrgAzureDevOpsOrgsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _devOpsOrgAzureDevOpsOrgsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DevOpsOrgResource(Client, DevOpsOrgData.DeserializeDevOpsOrgData(e)), _devOpsOrgAzureDevOpsOrgsClientDiagnostics, Pipeline, "DevOpsOrgCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orgName"> The Azure DevOps organization name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="orgName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="orgName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string orgName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(orgName, nameof(orgName));

            using var scope = _devOpsOrgAzureDevOpsOrgsClientDiagnostics.CreateScope("DevOpsOrgCollection.Exists");
            scope.Start();
            try
            {
                var response = await _devOpsOrgAzureDevOpsOrgsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orgName"> The Azure DevOps organization name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="orgName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="orgName"/> is null. </exception>
        public virtual Response<bool> Exists(string orgName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(orgName, nameof(orgName));

            using var scope = _devOpsOrgAzureDevOpsOrgsClientDiagnostics.CreateScope("DevOpsOrgCollection.Exists");
            scope.Start();
            try
            {
                var response = _devOpsOrgAzureDevOpsOrgsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orgName"> The Azure DevOps organization name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="orgName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="orgName"/> is null. </exception>
        public virtual async Task<NullableResponse<DevOpsOrgResource>> GetIfExistsAsync(string orgName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(orgName, nameof(orgName));

            using var scope = _devOpsOrgAzureDevOpsOrgsClientDiagnostics.CreateScope("DevOpsOrgCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _devOpsOrgAzureDevOpsOrgsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DevOpsOrgResource>(response.GetRawResponse());
                return Response.FromValue(new DevOpsOrgResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/azureDevOpsOrgs/{orgName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsOrgs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DevOpsOrgResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orgName"> The Azure DevOps organization name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="orgName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="orgName"/> is null. </exception>
        public virtual NullableResponse<DevOpsOrgResource> GetIfExists(string orgName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(orgName, nameof(orgName));

            using var scope = _devOpsOrgAzureDevOpsOrgsClientDiagnostics.CreateScope("DevOpsOrgCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _devOpsOrgAzureDevOpsOrgsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, orgName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DevOpsOrgResource>(response.GetRawResponse());
                return Response.FromValue(new DevOpsOrgResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DevOpsOrgResource> IEnumerable<DevOpsOrgResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DevOpsOrgResource> IAsyncEnumerable<DevOpsOrgResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
