// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing the DefenderForStorageSetting data model.
    /// The Defender for Storage resource.
    /// </summary>
    public partial class DefenderForStorageSettingData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DefenderForStorageSettingData"/>. </summary>
        public DefenderForStorageSettingData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DefenderForStorageSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isEnabled"> Indicates whether Defender for Storage is enabled on this storage account. </param>
        /// <param name="isOverrideSubscriptionLevelSettingsEnabled"> Indicates whether the settings defined for this storage account should override the settings defined for the subscription. </param>
        /// <param name="isSensitiveDataDiscoveryEnabled"> Indicates whether Sensitive Data Discovery should be enabled. </param>
        /// <param name="sensitiveDataDiscoveryOperationStatus"> Upon failure or partial success. Additional data describing Sensitive Data Discovery enable/disable operation. </param>
        /// <param name="scanResultsEventGridTopicResourceId"> Optional. Resource id of an Event Grid Topic to send scan results to. </param>
        /// <param name="malwareScanningOperationStatus"> Upon failure or partial success. Additional data describing Malware Scanning enable/disable operation. </param>
        /// <param name="isMalwareScanningOnUploadEnabled"> Indicates whether On Upload malware scanning should be enabled. </param>
        /// <param name="capGBPerMonth"> Defines the max GB to be scanned per Month. Set to -1 if no capping is needed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DefenderForStorageSettingData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, bool? isEnabled, bool? isOverrideSubscriptionLevelSettingsEnabled, bool? isSensitiveDataDiscoveryEnabled, ExtensionOperationStatus sensitiveDataDiscoveryOperationStatus, ResourceIdentifier scanResultsEventGridTopicResourceId, ExtensionOperationStatus malwareScanningOperationStatus, bool? isMalwareScanningOnUploadEnabled, int? capGBPerMonth, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            IsEnabled = isEnabled;
            IsOverrideSubscriptionLevelSettingsEnabled = isOverrideSubscriptionLevelSettingsEnabled;
            IsSensitiveDataDiscoveryEnabled = isSensitiveDataDiscoveryEnabled;
            SensitiveDataDiscoveryOperationStatus = sensitiveDataDiscoveryOperationStatus;
            ScanResultsEventGridTopicResourceId = scanResultsEventGridTopicResourceId;
            MalwareScanningOperationStatus = malwareScanningOperationStatus;
            IsMalwareScanningOnUploadEnabled = isMalwareScanningOnUploadEnabled;
            CapGBPerMonth = capGBPerMonth;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Indicates whether Defender for Storage is enabled on this storage account. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> Indicates whether the settings defined for this storage account should override the settings defined for the subscription. </summary>
        public bool? IsOverrideSubscriptionLevelSettingsEnabled { get; set; }
        /// <summary> Indicates whether Sensitive Data Discovery should be enabled. </summary>
        public bool? IsSensitiveDataDiscoveryEnabled { get; set; }
        /// <summary> Upon failure or partial success. Additional data describing Sensitive Data Discovery enable/disable operation. </summary>
        public ExtensionOperationStatus SensitiveDataDiscoveryOperationStatus { get; }
        /// <summary> Optional. Resource id of an Event Grid Topic to send scan results to. </summary>
        public ResourceIdentifier ScanResultsEventGridTopicResourceId { get; set; }
        /// <summary> Upon failure or partial success. Additional data describing Malware Scanning enable/disable operation. </summary>
        public ExtensionOperationStatus MalwareScanningOperationStatus { get; }
        /// <summary> Indicates whether On Upload malware scanning should be enabled. </summary>
        public bool? IsMalwareScanningOnUploadEnabled { get; set; }
        /// <summary> Defines the max GB to be scanned per Month. Set to -1 if no capping is needed. </summary>
        public int? CapGBPerMonth { get; set; }
    }
}
