// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    public partial class DefenderForStorageSettingData : IUtf8JsonSerializable, IJsonModel<DefenderForStorageSettingData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DefenderForStorageSettingData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DefenderForStorageSettingData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DefenderForStorageSettingData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DefenderForStorageSettingData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(IsEnabled))
            {
                writer.WritePropertyName("isEnabled"u8);
                writer.WriteBooleanValue(IsEnabled.Value);
            }
            if (Optional.IsDefined(IsOverrideSubscriptionLevelSettingsEnabled))
            {
                writer.WritePropertyName("overrideSubscriptionLevelSettings"u8);
                writer.WriteBooleanValue(IsOverrideSubscriptionLevelSettingsEnabled.Value);
            }
            writer.WritePropertyName("sensitiveDataDiscovery"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(IsSensitiveDataDiscoveryEnabled))
            {
                writer.WritePropertyName("isEnabled"u8);
                writer.WriteBooleanValue(IsSensitiveDataDiscoveryEnabled.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SensitiveDataDiscoveryOperationStatus))
            {
                writer.WritePropertyName("operationStatus"u8);
                writer.WriteObjectValue(SensitiveDataDiscoveryOperationStatus, options);
            }
            writer.WriteEndObject();
            writer.WritePropertyName("malwareScanning"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(ScanResultsEventGridTopicResourceId))
            {
                writer.WritePropertyName("scanResultsEventGridTopicResourceId"u8);
                writer.WriteStringValue(ScanResultsEventGridTopicResourceId);
            }
            if (options.Format != "W" && Optional.IsDefined(MalwareScanningOperationStatus))
            {
                writer.WritePropertyName("operationStatus"u8);
                writer.WriteObjectValue(MalwareScanningOperationStatus, options);
            }
            writer.WritePropertyName("onUpload"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(IsMalwareScanningOnUploadEnabled))
            {
                writer.WritePropertyName("isEnabled"u8);
                writer.WriteBooleanValue(IsMalwareScanningOnUploadEnabled.Value);
            }
            if (Optional.IsDefined(CapGBPerMonth))
            {
                writer.WritePropertyName("capGBPerMonth"u8);
                writer.WriteNumberValue(CapGBPerMonth.Value);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        DefenderForStorageSettingData IJsonModel<DefenderForStorageSettingData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DefenderForStorageSettingData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DefenderForStorageSettingData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDefenderForStorageSettingData(document.RootElement, options);
        }

        internal static DefenderForStorageSettingData DeserializeDefenderForStorageSettingData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            bool? isEnabled = default;
            bool? overrideSubscriptionLevelSettings = default;
            bool? isEnabled0 = default;
            ExtensionOperationStatus operationStatus = default;
            ResourceIdentifier scanResultsEventGridTopicResourceId = default;
            ExtensionOperationStatus operationStatus0 = default;
            bool? isEnabled1 = default;
            int? capGBPerMonth = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("isEnabled"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isEnabled = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("overrideSubscriptionLevelSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            overrideSubscriptionLevelSettings = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("sensitiveDataDiscovery"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("isEnabled"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    isEnabled0 = property1.Value.GetBoolean();
                                    continue;
                                }
                                if (property1.NameEquals("operationStatus"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    operationStatus = ExtensionOperationStatus.DeserializeExtensionOperationStatus(property1.Value, options);
                                    continue;
                                }
                            }
                            continue;
                        }
                        if (property0.NameEquals("malwareScanning"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("scanResultsEventGridTopicResourceId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    scanResultsEventGridTopicResourceId = new ResourceIdentifier(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("operationStatus"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    operationStatus0 = ExtensionOperationStatus.DeserializeExtensionOperationStatus(property1.Value, options);
                                    continue;
                                }
                                if (property1.NameEquals("onUpload"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        property1.ThrowNonNullablePropertyIsNull();
                                        continue;
                                    }
                                    foreach (var property2 in property1.Value.EnumerateObject())
                                    {
                                        if (property2.NameEquals("isEnabled"u8))
                                        {
                                            if (property2.Value.ValueKind == JsonValueKind.Null)
                                            {
                                                continue;
                                            }
                                            isEnabled1 = property2.Value.GetBoolean();
                                            continue;
                                        }
                                        if (property2.NameEquals("capGBPerMonth"u8))
                                        {
                                            if (property2.Value.ValueKind == JsonValueKind.Null)
                                            {
                                                continue;
                                            }
                                            capGBPerMonth = property2.Value.GetInt32();
                                            continue;
                                        }
                                    }
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DefenderForStorageSettingData(
                id,
                name,
                type,
                systemData,
                isEnabled,
                overrideSubscriptionLevelSettings,
                isEnabled0,
                operationStatus,
                scanResultsEventGridTopicResourceId,
                operationStatus0,
                isEnabled1,
                capGBPerMonth,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DefenderForStorageSettingData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DefenderForStorageSettingData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DefenderForStorageSettingData)} does not support writing '{options.Format}' format.");
            }
        }

        DefenderForStorageSettingData IPersistableModel<DefenderForStorageSettingData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DefenderForStorageSettingData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDefenderForStorageSettingData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DefenderForStorageSettingData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DefenderForStorageSettingData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
