// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="ComplianceResultResource"/> and their operations.
    /// Each <see cref="ComplianceResultResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="ComplianceResultCollection"/> instance call the GetComplianceResults method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class ComplianceResultCollection : ArmCollection, IEnumerable<ComplianceResultResource>, IAsyncEnumerable<ComplianceResultResource>
    {
        private readonly ClientDiagnostics _complianceResultClientDiagnostics;
        private readonly ComplianceResultsRestOperations _complianceResultRestClient;

        /// <summary> Initializes a new instance of the <see cref="ComplianceResultCollection"/> class for mocking. </summary>
        protected ComplianceResultCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ComplianceResultCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ComplianceResultCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _complianceResultClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ComplianceResultResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ComplianceResultResource.ResourceType, out string complianceResultApiVersion);
            _complianceResultRestClient = new ComplianceResultsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, complianceResultApiVersion);
        }

        /// <summary>
        /// Security Compliance Result
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/complianceResults/{complianceResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComplianceResults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComplianceResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceResultName"> name of the desired assessment compliance result. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceResultName"/> is null. </exception>
        public virtual async Task<Response<ComplianceResultResource>> GetAsync(string complianceResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceResultName, nameof(complianceResultName));

            using var scope = _complianceResultClientDiagnostics.CreateScope("ComplianceResultCollection.Get");
            scope.Start();
            try
            {
                var response = await _complianceResultRestClient.GetAsync(Id, complianceResultName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ComplianceResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Security Compliance Result
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/complianceResults/{complianceResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComplianceResults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComplianceResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceResultName"> name of the desired assessment compliance result. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceResultName"/> is null. </exception>
        public virtual Response<ComplianceResultResource> Get(string complianceResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceResultName, nameof(complianceResultName));

            using var scope = _complianceResultClientDiagnostics.CreateScope("ComplianceResultCollection.Get");
            scope.Start();
            try
            {
                var response = _complianceResultRestClient.Get(Id, complianceResultName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ComplianceResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Security compliance results in the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/complianceResults</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComplianceResults_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComplianceResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ComplianceResultResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ComplianceResultResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _complianceResultRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _complianceResultRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ComplianceResultResource(Client, ComplianceResultData.DeserializeComplianceResultData(e)), _complianceResultClientDiagnostics, Pipeline, "ComplianceResultCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Security compliance results in the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/complianceResults</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComplianceResults_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComplianceResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ComplianceResultResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ComplianceResultResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _complianceResultRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _complianceResultRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ComplianceResultResource(Client, ComplianceResultData.DeserializeComplianceResultData(e)), _complianceResultClientDiagnostics, Pipeline, "ComplianceResultCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/complianceResults/{complianceResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComplianceResults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComplianceResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceResultName"> name of the desired assessment compliance result. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceResultName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string complianceResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceResultName, nameof(complianceResultName));

            using var scope = _complianceResultClientDiagnostics.CreateScope("ComplianceResultCollection.Exists");
            scope.Start();
            try
            {
                var response = await _complianceResultRestClient.GetAsync(Id, complianceResultName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/complianceResults/{complianceResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComplianceResults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComplianceResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceResultName"> name of the desired assessment compliance result. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceResultName"/> is null. </exception>
        public virtual Response<bool> Exists(string complianceResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceResultName, nameof(complianceResultName));

            using var scope = _complianceResultClientDiagnostics.CreateScope("ComplianceResultCollection.Exists");
            scope.Start();
            try
            {
                var response = _complianceResultRestClient.Get(Id, complianceResultName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/complianceResults/{complianceResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComplianceResults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComplianceResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceResultName"> name of the desired assessment compliance result. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceResultName"/> is null. </exception>
        public virtual async Task<NullableResponse<ComplianceResultResource>> GetIfExistsAsync(string complianceResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceResultName, nameof(complianceResultName));

            using var scope = _complianceResultClientDiagnostics.CreateScope("ComplianceResultCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _complianceResultRestClient.GetAsync(Id, complianceResultName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ComplianceResultResource>(response.GetRawResponse());
                return Response.FromValue(new ComplianceResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/complianceResults/{complianceResultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ComplianceResults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComplianceResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceResultName"> name of the desired assessment compliance result. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceResultName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceResultName"/> is null. </exception>
        public virtual NullableResponse<ComplianceResultResource> GetIfExists(string complianceResultName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceResultName, nameof(complianceResultName));

            using var scope = _complianceResultClientDiagnostics.CreateScope("ComplianceResultCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _complianceResultRestClient.Get(Id, complianceResultName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ComplianceResultResource>(response.GetRawResponse());
                return Response.FromValue(new ComplianceResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ComplianceResultResource> IEnumerable<ComplianceResultResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ComplianceResultResource> IAsyncEnumerable<ComplianceResultResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
