// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A Class representing an AdvancedThreatProtectionSetting along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="AdvancedThreatProtectionSettingResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetAdvancedThreatProtectionSettingResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetAdvancedThreatProtectionSetting method.
    /// </summary>
    public partial class AdvancedThreatProtectionSettingResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="AdvancedThreatProtectionSettingResource"/> instance. </summary>
        /// <param name="resourceId"> The resourceId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceId)
        {
            var resourceId0 = $"{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/current";
            return new ResourceIdentifier(resourceId0);
        }

        private readonly ClientDiagnostics _advancedThreatProtectionSettingAdvancedThreatProtectionClientDiagnostics;
        private readonly AdvancedThreatProtectionRestOperations _advancedThreatProtectionSettingAdvancedThreatProtectionRestClient;
        private readonly AdvancedThreatProtectionSettingData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Security/advancedThreatProtectionSettings";

        /// <summary> Initializes a new instance of the <see cref="AdvancedThreatProtectionSettingResource"/> class for mocking. </summary>
        protected AdvancedThreatProtectionSettingResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AdvancedThreatProtectionSettingResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal AdvancedThreatProtectionSettingResource(ArmClient client, AdvancedThreatProtectionSettingData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="AdvancedThreatProtectionSettingResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal AdvancedThreatProtectionSettingResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _advancedThreatProtectionSettingAdvancedThreatProtectionClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string advancedThreatProtectionSettingAdvancedThreatProtectionApiVersion);
            _advancedThreatProtectionSettingAdvancedThreatProtectionRestClient = new AdvancedThreatProtectionRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, advancedThreatProtectionSettingAdvancedThreatProtectionApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual AdvancedThreatProtectionSettingData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the Advanced Threat Protection settings for the specified resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtection_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<AdvancedThreatProtectionSettingResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _advancedThreatProtectionSettingAdvancedThreatProtectionClientDiagnostics.CreateScope("AdvancedThreatProtectionSettingResource.Get");
            scope.Start();
            try
            {
                var response = await _advancedThreatProtectionSettingAdvancedThreatProtectionRestClient.GetAsync(Id.Parent, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AdvancedThreatProtectionSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the Advanced Threat Protection settings for the specified resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtection_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<AdvancedThreatProtectionSettingResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _advancedThreatProtectionSettingAdvancedThreatProtectionClientDiagnostics.CreateScope("AdvancedThreatProtectionSettingResource.Get");
            scope.Start();
            try
            {
                var response = _advancedThreatProtectionSettingAdvancedThreatProtectionRestClient.Get(Id.Parent, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AdvancedThreatProtectionSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates the Advanced Threat Protection settings on a specified resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtection_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Advanced Threat Protection Settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AdvancedThreatProtectionSettingResource>> CreateOrUpdateAsync(WaitUntil waitUntil, AdvancedThreatProtectionSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _advancedThreatProtectionSettingAdvancedThreatProtectionClientDiagnostics.CreateScope("AdvancedThreatProtectionSettingResource.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _advancedThreatProtectionSettingAdvancedThreatProtectionRestClient.CreateAsync(Id.Parent, data, cancellationToken).ConfigureAwait(false);
                var uri = _advancedThreatProtectionSettingAdvancedThreatProtectionRestClient.CreateCreateRequestUri(Id.Parent, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<AdvancedThreatProtectionSettingResource>(Response.FromValue(new AdvancedThreatProtectionSettingResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates the Advanced Threat Protection settings on a specified resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AdvancedThreatProtection_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AdvancedThreatProtectionSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Advanced Threat Protection Settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AdvancedThreatProtectionSettingResource> CreateOrUpdate(WaitUntil waitUntil, AdvancedThreatProtectionSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _advancedThreatProtectionSettingAdvancedThreatProtectionClientDiagnostics.CreateScope("AdvancedThreatProtectionSettingResource.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _advancedThreatProtectionSettingAdvancedThreatProtectionRestClient.Create(Id.Parent, data, cancellationToken);
                var uri = _advancedThreatProtectionSettingAdvancedThreatProtectionRestClient.CreateCreateRequestUri(Id.Parent, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<AdvancedThreatProtectionSettingResource>(Response.FromValue(new AdvancedThreatProtectionSettingResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
