// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    public partial class AdaptiveNetworkHardeningData : IUtf8JsonSerializable, IJsonModel<AdaptiveNetworkHardeningData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AdaptiveNetworkHardeningData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AdaptiveNetworkHardeningData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdaptiveNetworkHardeningData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AdaptiveNetworkHardeningData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Rules))
            {
                writer.WritePropertyName("rules"u8);
                writer.WriteStartArray();
                foreach (var item in Rules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(RulesCalculatedOn))
            {
                writer.WritePropertyName("rulesCalculationTime"u8);
                writer.WriteStringValue(RulesCalculatedOn.Value, "O");
            }
            if (Optional.IsCollectionDefined(EffectiveNetworkSecurityGroups))
            {
                writer.WritePropertyName("effectiveNetworkSecurityGroups"u8);
                writer.WriteStartArray();
                foreach (var item in EffectiveNetworkSecurityGroups)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        AdaptiveNetworkHardeningData IJsonModel<AdaptiveNetworkHardeningData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdaptiveNetworkHardeningData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AdaptiveNetworkHardeningData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAdaptiveNetworkHardeningData(document.RootElement, options);
        }

        internal static AdaptiveNetworkHardeningData DeserializeAdaptiveNetworkHardeningData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            IList<RecommendedSecurityRule> rules = default;
            DateTimeOffset? rulesCalculationTime = default;
            IList<EffectiveNetworkSecurityGroups> effectiveNetworkSecurityGroups = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("rules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<RecommendedSecurityRule> array = new List<RecommendedSecurityRule>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(RecommendedSecurityRule.DeserializeRecommendedSecurityRule(item, options));
                            }
                            rules = array;
                            continue;
                        }
                        if (property0.NameEquals("rulesCalculationTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            rulesCalculationTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("effectiveNetworkSecurityGroups"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<EffectiveNetworkSecurityGroups> array = new List<EffectiveNetworkSecurityGroups>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(Models.EffectiveNetworkSecurityGroups.DeserializeEffectiveNetworkSecurityGroups(item, options));
                            }
                            effectiveNetworkSecurityGroups = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AdaptiveNetworkHardeningData(
                id,
                name,
                type,
                systemData,
                rules ?? new ChangeTrackingList<RecommendedSecurityRule>(),
                rulesCalculationTime,
                effectiveNetworkSecurityGroups ?? new ChangeTrackingList<EffectiveNetworkSecurityGroups>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AdaptiveNetworkHardeningData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdaptiveNetworkHardeningData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AdaptiveNetworkHardeningData)} does not support writing '{options.Format}' format.");
            }
        }

        AdaptiveNetworkHardeningData IPersistableModel<AdaptiveNetworkHardeningData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdaptiveNetworkHardeningData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAdaptiveNetworkHardeningData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AdaptiveNetworkHardeningData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AdaptiveNetworkHardeningData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
