// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    public partial class AdaptiveApplicationControlGroupData : IUtf8JsonSerializable, IJsonModel<AdaptiveApplicationControlGroupData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AdaptiveApplicationControlGroupData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AdaptiveApplicationControlGroupData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdaptiveApplicationControlGroupData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AdaptiveApplicationControlGroupData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(EnforcementMode))
            {
                writer.WritePropertyName("enforcementMode"u8);
                writer.WriteStringValue(EnforcementMode.Value.ToString());
            }
            if (Optional.IsDefined(ProtectionMode))
            {
                writer.WritePropertyName("protectionMode"u8);
                writer.WriteObjectValue(ProtectionMode, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ConfigurationStatus))
            {
                writer.WritePropertyName("configurationStatus"u8);
                writer.WriteStringValue(ConfigurationStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RecommendationStatus))
            {
                writer.WritePropertyName("recommendationStatus"u8);
                writer.WriteStringValue(RecommendationStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Issues))
            {
                writer.WritePropertyName("issues"u8);
                writer.WriteStartArray();
                foreach (var item in Issues)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(SourceSystem))
            {
                writer.WritePropertyName("sourceSystem"u8);
                writer.WriteStringValue(SourceSystem.Value.ToString());
            }
            if (Optional.IsCollectionDefined(VmRecommendations))
            {
                writer.WritePropertyName("vmRecommendations"u8);
                writer.WriteStartArray();
                foreach (var item in VmRecommendations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PathRecommendations))
            {
                writer.WritePropertyName("pathRecommendations"u8);
                writer.WriteStartArray();
                foreach (var item in PathRecommendations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        AdaptiveApplicationControlGroupData IJsonModel<AdaptiveApplicationControlGroupData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdaptiveApplicationControlGroupData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AdaptiveApplicationControlGroupData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAdaptiveApplicationControlGroupData(document.RootElement, options);
        }

        internal static AdaptiveApplicationControlGroupData DeserializeAdaptiveApplicationControlGroupData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AzureLocation? location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            AdaptiveApplicationControlEnforcementMode? enforcementMode = default;
            SecurityCenterFileProtectionMode protectionMode = default;
            SecurityCenterConfigurationStatus? configurationStatus = default;
            RecommendationStatus? recommendationStatus = default;
            IReadOnlyList<AdaptiveApplicationControlIssueSummary> issues = default;
            AdaptiveApplicationControlGroupSourceSystem? sourceSystem = default;
            IList<VmRecommendation> vmRecommendations = default;
            IList<PathRecommendation> pathRecommendations = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("enforcementMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enforcementMode = new AdaptiveApplicationControlEnforcementMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("protectionMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            protectionMode = SecurityCenterFileProtectionMode.DeserializeSecurityCenterFileProtectionMode(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("configurationStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            configurationStatus = new SecurityCenterConfigurationStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("recommendationStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            recommendationStatus = new RecommendationStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("issues"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<AdaptiveApplicationControlIssueSummary> array = new List<AdaptiveApplicationControlIssueSummary>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(AdaptiveApplicationControlIssueSummary.DeserializeAdaptiveApplicationControlIssueSummary(item, options));
                            }
                            issues = array;
                            continue;
                        }
                        if (property0.NameEquals("sourceSystem"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sourceSystem = new AdaptiveApplicationControlGroupSourceSystem(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("vmRecommendations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<VmRecommendation> array = new List<VmRecommendation>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(VmRecommendation.DeserializeVmRecommendation(item, options));
                            }
                            vmRecommendations = array;
                            continue;
                        }
                        if (property0.NameEquals("pathRecommendations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<PathRecommendation> array = new List<PathRecommendation>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(PathRecommendation.DeserializePathRecommendation(item, options));
                            }
                            pathRecommendations = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AdaptiveApplicationControlGroupData(
                id,
                name,
                type,
                systemData,
                enforcementMode,
                protectionMode,
                configurationStatus,
                recommendationStatus,
                issues ?? new ChangeTrackingList<AdaptiveApplicationControlIssueSummary>(),
                sourceSystem,
                vmRecommendations ?? new ChangeTrackingList<VmRecommendation>(),
                pathRecommendations ?? new ChangeTrackingList<PathRecommendation>(),
                location,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AdaptiveApplicationControlGroupData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdaptiveApplicationControlGroupData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AdaptiveApplicationControlGroupData)} does not support writing '{options.Format}' format.");
            }
        }

        AdaptiveApplicationControlGroupData IPersistableModel<AdaptiveApplicationControlGroupData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AdaptiveApplicationControlGroupData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAdaptiveApplicationControlGroupData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AdaptiveApplicationControlGroupData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AdaptiveApplicationControlGroupData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
