// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#nullable disable

using System;
using System.ComponentModel;
using System.Threading;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlVulnerabilityAssessmentBaselineRuleResource" /> and their operations.
    /// Each <see cref="SqlVulnerabilityAssessmentBaselineRuleResource" /> in the collection will belong to the same instance of <see cref="ArmResource" />.
    /// To get a <see cref="SqlVulnerabilityAssessmentBaselineRuleCollection" /> instance call the GetSqlVulnerabilityAssessmentBaselineRules method from an instance of <see cref="ArmResource" />.
    /// </summary>
    public partial class SqlVulnerabilityAssessmentBaselineRuleCollection : ArmCollection
    {
        /// <summary>
        /// Add a list of baseline rules. Will overwrite any previously existing results (for all rules).
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Add</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="content"> The baseline rules. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlVulnerabilityAssessmentBaselineRuleResource" /> that may take multiple service requests to iterate over. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        [Obsolete("This method is obsolete and will be removed in a future release. Please use AddRulesAsync().", false)]
        public virtual AsyncPageable<SqlVulnerabilityAssessmentBaselineRuleResource> GetAllAsync(Guid workspaceId, RulesResultsContent content, CancellationToken cancellationToken = default)
        {
            return AddRulesAsync(workspaceId, content, cancellationToken);
        }

        /// <summary>
        /// Add a list of baseline rules. Will overwrite any previously existing results (for all rules).
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Add</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="content"> The baseline rules. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlVulnerabilityAssessmentBaselineRuleResource" /> that may take multiple service requests to iterate over. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        [Obsolete("This method is obsolete and will be removed in a future release. Please use AddRules().", false)]
        public virtual Pageable<SqlVulnerabilityAssessmentBaselineRuleResource> GetAll(Guid workspaceId, RulesResultsContent content = null, CancellationToken cancellationToken = default)
        {
            return AddRules(workspaceId, content, cancellationToken);
        }

        /// <summary>
        /// Add a list of baseline rules. Will overwrite any previously existing results (for all rules).
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Add</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="content"> The baseline rules. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlVulnerabilityAssessmentBaselineRuleResource" /> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlVulnerabilityAssessmentBaselineRuleResource> AddRulesAsync(Guid workspaceId, RulesResultsContent content = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateAddRequest(Id, workspaceId, content);
            return PageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new SqlVulnerabilityAssessmentBaselineRuleResource(Client, SqlVulnerabilityAssessmentBaselineRuleData.DeserializeSqlVulnerabilityAssessmentBaselineRuleData(e)), _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics, Pipeline, "SqlVulnerabilityAssessmentBaselineRuleCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Add a list of baseline rules. Will overwrite any previously existing results (for all rules).
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Add</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="content"> The baseline rules. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlVulnerabilityAssessmentBaselineRuleResource" /> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlVulnerabilityAssessmentBaselineRuleResource> AddRules(Guid workspaceId, RulesResultsContent content = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateAddRequest(Id, workspaceId, content);
            return PageableHelpers.CreatePageable(FirstPageRequest, null, e => new SqlVulnerabilityAssessmentBaselineRuleResource(Client, SqlVulnerabilityAssessmentBaselineRuleData.DeserializeSqlVulnerabilityAssessmentBaselineRuleData(e)), _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics, Pipeline, "SqlVulnerabilityAssessmentBaselineRuleCollection.GetAll", "value", null, cancellationToken);
        }
    }
}
