// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_TenantAssessmentMetadataResource
    {
        // Get security assessment metadata
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSecurityAssessmentMetadata()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2021-06-01/examples/AssessmentsMetadata/GetAssessmentsMetadata_example.json
            // this example is just showing the usage of "AssessmentsMetadata_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantAssessmentMetadataResource created on azure
            // for more information of creating TenantAssessmentMetadataResource, please refer to the document of TenantAssessmentMetadataResource
            string assessmentMetadataName = "21300918-b2e3-0346-785f-c77ff57d243b";
            ResourceIdentifier tenantAssessmentMetadataResourceId = TenantAssessmentMetadataResource.CreateResourceIdentifier(assessmentMetadataName);
            TenantAssessmentMetadataResource tenantAssessmentMetadata = client.GetTenantAssessmentMetadataResource(tenantAssessmentMetadataResourceId);

            // invoke the operation
            TenantAssessmentMetadataResource result = await tenantAssessmentMetadata.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityAssessmentMetadataData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
