// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SqlVulnerabilityAssessmentScanResource
    {
        // Get scan details of a scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetScanDetailsOfAScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentScanResource, please refer to the document of SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string scanId = "Scheduled-20200623";
            ResourceIdentifier sqlVulnerabilityAssessmentScanResourceId = SqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(resourceId, scanId);
            SqlVulnerabilityAssessmentScanResource sqlVulnerabilityAssessmentScan = client.GetSqlVulnerabilityAssessmentScanResource(sqlVulnerabilityAssessmentScanResourceId);

            // invoke the operation
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentScanResource result = await sqlVulnerabilityAssessmentScan.GetAsync(workspaceId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentScanData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get scan details of the latest scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetScanDetailsOfTheLatestScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_GetLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentScanResource, please refer to the document of SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string scanId = "latest";
            ResourceIdentifier sqlVulnerabilityAssessmentScanResourceId = SqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(resourceId, scanId);
            SqlVulnerabilityAssessmentScanResource sqlVulnerabilityAssessmentScan = client.GetSqlVulnerabilityAssessmentScanResource(sqlVulnerabilityAssessmentScanResourceId);

            // invoke the operation
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentScanResource result = await sqlVulnerabilityAssessmentScan.GetAsync(workspaceId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentScanData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get scan details of a scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSqlVulnerabilityAssessmentScanResult_GetScanDetailsOfAScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsScanResultsOperations/ArcMachineScanResults_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScanResults_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentScanResource, please refer to the document of SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string scanId = "Scheduled-20200623";
            ResourceIdentifier sqlVulnerabilityAssessmentScanResourceId = SqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(resourceId, scanId);
            SqlVulnerabilityAssessmentScanResource sqlVulnerabilityAssessmentScan = client.GetSqlVulnerabilityAssessmentScanResource(sqlVulnerabilityAssessmentScanResourceId);

            // invoke the operation
            string scanResultId = "VA2063";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentScanResult result = await sqlVulnerabilityAssessmentScan.GetSqlVulnerabilityAssessmentScanResultAsync(scanResultId, workspaceId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get scan details of the latest scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSqlVulnerabilityAssessmentScanResult_GetScanDetailsOfTheLatestScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsScanResultsOperations/ArcMachineScanResults_GetLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScanResults_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentScanResource, please refer to the document of SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string scanId = "latest";
            ResourceIdentifier sqlVulnerabilityAssessmentScanResourceId = SqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(resourceId, scanId);
            SqlVulnerabilityAssessmentScanResource sqlVulnerabilityAssessmentScan = client.GetSqlVulnerabilityAssessmentScanResource(sqlVulnerabilityAssessmentScanResourceId);

            // invoke the operation
            string scanResultId = "VA2063";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentScanResult result = await sqlVulnerabilityAssessmentScan.GetSqlVulnerabilityAssessmentScanResultAsync(scanResultId, workspaceId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // List scan results
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSqlVulnerabilityAssessmentScanResults_ListScanResults()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsScanResultsOperations/ArcMachineScanResults_List.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScanResults_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentScanResource, please refer to the document of SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string scanId = "Scheduled-20200623";
            ResourceIdentifier sqlVulnerabilityAssessmentScanResourceId = SqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(resourceId, scanId);
            SqlVulnerabilityAssessmentScanResource sqlVulnerabilityAssessmentScan = client.GetSqlVulnerabilityAssessmentScanResource(sqlVulnerabilityAssessmentScanResourceId);

            // invoke the operation and iterate over the result
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            await foreach (SqlVulnerabilityAssessmentScanResult item in sqlVulnerabilityAssessmentScan.GetSqlVulnerabilityAssessmentScanResultsAsync(workspaceId))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List scan results of the latest scan
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSqlVulnerabilityAssessmentScanResults_ListScanResultsOfTheLatestScan()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsScanResultsOperations/ArcMachineScanResults_ListLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScanResults_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentScanResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentScanResource, please refer to the document of SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string scanId = "latest";
            ResourceIdentifier sqlVulnerabilityAssessmentScanResourceId = SqlVulnerabilityAssessmentScanResource.CreateResourceIdentifier(resourceId, scanId);
            SqlVulnerabilityAssessmentScanResource sqlVulnerabilityAssessmentScan = client.GetSqlVulnerabilityAssessmentScanResource(sqlVulnerabilityAssessmentScanResourceId);

            // invoke the operation and iterate over the result
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            await foreach (SqlVulnerabilityAssessmentScanResult item in sqlVulnerabilityAssessmentScan.GetSqlVulnerabilityAssessmentScanResultsAsync(workspaceId))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
