// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SqlVulnerabilityAssessmentScanCollection
    {
        // Get scan details of a scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetScanDetailsOfAScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentScanCollection collection = client.GetSqlVulnerabilityAssessmentScans(scopeId);

            // invoke the operation
            string scanId = "Scheduled-20200623";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentScanResource result = await collection.GetAsync(scanId, workspaceId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentScanData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get scan details of a scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetScanDetailsOfAScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentScanCollection collection = client.GetSqlVulnerabilityAssessmentScans(scopeId);

            // invoke the operation
            string scanId = "Scheduled-20200623";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            bool result = await collection.ExistsAsync(scanId, workspaceId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get scan details of a scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetScanDetailsOfAScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentScanCollection collection = client.GetSqlVulnerabilityAssessmentScans(scopeId);

            // invoke the operation
            string scanId = "Scheduled-20200623";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            NullableResponse<SqlVulnerabilityAssessmentScanResource> response = await collection.GetIfExistsAsync(scanId, workspaceId);
            SqlVulnerabilityAssessmentScanResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentScanData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get scan details of the latest scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetScanDetailsOfTheLatestScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_GetLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentScanCollection collection = client.GetSqlVulnerabilityAssessmentScans(scopeId);

            // invoke the operation
            string scanId = "latest";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentScanResource result = await collection.GetAsync(scanId, workspaceId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentScanData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get scan details of the latest scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetScanDetailsOfTheLatestScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_GetLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentScanCollection collection = client.GetSqlVulnerabilityAssessmentScans(scopeId);

            // invoke the operation
            string scanId = "latest";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            bool result = await collection.ExistsAsync(scanId, workspaceId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get scan details of the latest scan record
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetScanDetailsOfTheLatestScanRecord()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_GetLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentScanCollection collection = client.GetSqlVulnerabilityAssessmentScans(scopeId);

            // invoke the operation
            string scanId = "latest";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            NullableResponse<SqlVulnerabilityAssessmentScanResource> response = await collection.GetIfExistsAsync(scanId, workspaceId);
            SqlVulnerabilityAssessmentScanResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentScanData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List scan details
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListScanDetails()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentScanOperations/ArcMachineScans_List.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentScans_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentScanResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentScanCollection collection = client.GetSqlVulnerabilityAssessmentScans(scopeId);

            // invoke the operation and iterate over the result
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            await foreach (SqlVulnerabilityAssessmentScanResource item in collection.GetAllAsync(workspaceId))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentScanData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
