// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SqlVulnerabilityAssessmentBaselineRuleResource
    {
        // Create a baseline
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateABaseline()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Put.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentBaselineRuleResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentBaselineRuleResource, please refer to the document of SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string ruleId = "VA1234";
            ResourceIdentifier sqlVulnerabilityAssessmentBaselineRuleResourceId = SqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier(resourceId, ruleId);
            SqlVulnerabilityAssessmentBaselineRuleResource sqlVulnerabilityAssessmentBaselineRule = client.GetSqlVulnerabilityAssessmentBaselineRuleResource(sqlVulnerabilityAssessmentBaselineRuleResourceId);

            // invoke the operation
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent()
            {
                LatestScan = false,
                Results =
{
new string[]
{
"userA","SELECT"
},new string[]
{
"userB","SELECT"
}
},
            };
            ArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource> lro = await sqlVulnerabilityAssessmentBaselineRule.UpdateAsync(WaitUntil.Completed, workspaceId, content);
            SqlVulnerabilityAssessmentBaselineRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a baseline using the latest scan results
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateABaselineUsingTheLatestScanResults()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_PutLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentBaselineRuleResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentBaselineRuleResource, please refer to the document of SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string ruleId = "VA1234";
            ResourceIdentifier sqlVulnerabilityAssessmentBaselineRuleResourceId = SqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier(resourceId, ruleId);
            SqlVulnerabilityAssessmentBaselineRuleResource sqlVulnerabilityAssessmentBaselineRule = client.GetSqlVulnerabilityAssessmentBaselineRuleResource(sqlVulnerabilityAssessmentBaselineRuleResourceId);

            // invoke the operation
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent()
            {
                LatestScan = true,
                Results =
{
},
            };
            ArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource> lro = await sqlVulnerabilityAssessmentBaselineRule.UpdateAsync(WaitUntil.Completed, workspaceId, content);
            SqlVulnerabilityAssessmentBaselineRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get the baseline
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheBaseline()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentBaselineRuleResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentBaselineRuleResource, please refer to the document of SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string ruleId = "VA1234";
            ResourceIdentifier sqlVulnerabilityAssessmentBaselineRuleResourceId = SqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier(resourceId, ruleId);
            SqlVulnerabilityAssessmentBaselineRuleResource sqlVulnerabilityAssessmentBaselineRule = client.GetSqlVulnerabilityAssessmentBaselineRuleResource(sqlVulnerabilityAssessmentBaselineRuleResourceId);

            // invoke the operation
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentBaselineRuleResource result = await sqlVulnerabilityAssessmentBaselineRule.GetAsync(workspaceId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete the baseline
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteTheBaseline()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Delete.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVulnerabilityAssessmentBaselineRuleResource created on azure
            // for more information of creating SqlVulnerabilityAssessmentBaselineRuleResource, please refer to the document of SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            string ruleId = "VA1234";
            ResourceIdentifier sqlVulnerabilityAssessmentBaselineRuleResourceId = SqlVulnerabilityAssessmentBaselineRuleResource.CreateResourceIdentifier(resourceId, ruleId);
            SqlVulnerabilityAssessmentBaselineRuleResource sqlVulnerabilityAssessmentBaselineRule = client.GetSqlVulnerabilityAssessmentBaselineRuleResource(sqlVulnerabilityAssessmentBaselineRuleResourceId);

            // invoke the operation
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            await sqlVulnerabilityAssessmentBaselineRule.DeleteAsync(WaitUntil.Completed, workspaceId);

            Console.WriteLine($"Succeeded");
        }
    }
}
