// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SqlVulnerabilityAssessmentBaselineRuleCollection
    {
        // Create a baseline
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateABaseline()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Put.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentBaselineRuleCollection collection = client.GetSqlVulnerabilityAssessmentBaselineRules(scopeId);

            // invoke the operation
            string ruleId = "VA1234";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent()
            {
                LatestScan = false,
                Results =
{
new string[]
{
"userA","SELECT"
},new string[]
{
"userB","SELECT"
}
},
            };
            ArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, ruleId, workspaceId, content);
            SqlVulnerabilityAssessmentBaselineRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a baseline using the latest scan results
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateABaselineUsingTheLatestScanResults()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_PutLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentBaselineRuleCollection collection = client.GetSqlVulnerabilityAssessmentBaselineRules(scopeId);

            // invoke the operation
            string ruleId = "VA1234";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content = new SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent()
            {
                LatestScan = true,
                Results =
{
},
            };
            ArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, ruleId, workspaceId, content);
            SqlVulnerabilityAssessmentBaselineRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get the baseline
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheBaseline()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentBaselineRuleCollection collection = client.GetSqlVulnerabilityAssessmentBaselineRules(scopeId);

            // invoke the operation
            string ruleId = "VA1234";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            SqlVulnerabilityAssessmentBaselineRuleResource result = await collection.GetAsync(ruleId, workspaceId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get the baseline
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetTheBaseline()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentBaselineRuleCollection collection = client.GetSqlVulnerabilityAssessmentBaselineRules(scopeId);

            // invoke the operation
            string ruleId = "VA1234";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            bool result = await collection.ExistsAsync(ruleId, workspaceId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get the baseline
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetTheBaseline()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Get.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentBaselineRuleCollection collection = client.GetSqlVulnerabilityAssessmentBaselineRules(scopeId);

            // invoke the operation
            string ruleId = "VA1234";
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            NullableResponse<SqlVulnerabilityAssessmentBaselineRuleResource> response = await collection.GetIfExistsAsync(ruleId, workspaceId);
            SqlVulnerabilityAssessmentBaselineRuleResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentBaselineRuleData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List baseline for all rules
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListBaselineForAllRules()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_List.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentBaselineRuleCollection collection = client.GetSqlVulnerabilityAssessmentBaselineRules(scopeId);

            // invoke the operation and iterate over the result
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            await foreach (SqlVulnerabilityAssessmentBaselineRuleResource item in collection.GetAllAsync(workspaceId))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentBaselineRuleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Create a baseline for all rules
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_CreateABaselineForAllRules()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Add.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_Add" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentBaselineRuleCollection collection = client.GetSqlVulnerabilityAssessmentBaselineRules(scopeId);

            // invoke the operation and iterate over the result
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            RulesResultsContent content = new RulesResultsContent()
            {
                LatestScan = false,
                Results =
{
["VA1234"] = new IList<string>[]
{
new string[]
{
"userA","SELECT"
},new string[]
{
"userB","SELECT"
}
},
["VA5678"] = new IList<string>[]
{
new string[]
{
"Test","0.0.0.0","125.125.125.125"
}
},
},
            };
            await foreach (SqlVulnerabilityAssessmentBaselineRuleResource item in collection.GetAllAsync(workspaceId, content: content))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentBaselineRuleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Create a baseline for all rules using the latest scan results
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_CreateABaselineForAllRulesUsingTheLatestScanResults()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_AddLatest.json
            // this example is just showing the usage of "SqlVulnerabilityAssessmentBaselineRules_Add" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SqlVulnerabilityAssessmentBaselineRuleResource
            string resourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", resourceId));
            SqlVulnerabilityAssessmentBaselineRuleCollection collection = client.GetSqlVulnerabilityAssessmentBaselineRules(scopeId);

            // invoke the operation and iterate over the result
            Guid workspaceId = Guid.Parse("55555555-6666-7777-8888-999999999999");
            RulesResultsContent content = new RulesResultsContent()
            {
                LatestScan = true,
                Results =
{
},
            };
            await foreach (SqlVulnerabilityAssessmentBaselineRuleResource item in collection.GetAllAsync(workspaceId, content: content))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVulnerabilityAssessmentBaselineRuleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
