// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_ServerVulnerabilityAssessmentsSettingResource
    {
        // Get the server vulnerability assessments setting of the kind settingKind that is set on the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheServerVulnerabilityAssessmentsSettingOfTheKindSettingKindThatIsSetOnTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/GetServerVulnerabilityAssessmentsSetting_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessmentsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServerVulnerabilityAssessmentsSettingResource created on azure
            // for more information of creating ServerVulnerabilityAssessmentsSettingResource, please refer to the document of ServerVulnerabilityAssessmentsSettingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ServerVulnerabilityAssessmentsSettingKindName settingKind = ServerVulnerabilityAssessmentsSettingKindName.AzureServersSetting;
            ResourceIdentifier serverVulnerabilityAssessmentsSettingResourceId = ServerVulnerabilityAssessmentsSettingResource.CreateResourceIdentifier(subscriptionId, settingKind);
            ServerVulnerabilityAssessmentsSettingResource serverVulnerabilityAssessmentsSetting = client.GetServerVulnerabilityAssessmentsSettingResource(serverVulnerabilityAssessmentsSettingResourceId);

            // invoke the operation
            ServerVulnerabilityAssessmentsSettingResource result = await serverVulnerabilityAssessmentsSetting.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServerVulnerabilityAssessmentsSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Set a server vulnerability assessments setting of the kind settingKind on the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SetAServerVulnerabilityAssessmentsSettingOfTheKindSettingKindOnTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/PutServerVulnerabilityAssessmentsSetting_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessmentsSettings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServerVulnerabilityAssessmentsSettingResource created on azure
            // for more information of creating ServerVulnerabilityAssessmentsSettingResource, please refer to the document of ServerVulnerabilityAssessmentsSettingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ServerVulnerabilityAssessmentsSettingKindName settingKind = ServerVulnerabilityAssessmentsSettingKindName.AzureServersSetting;
            ResourceIdentifier serverVulnerabilityAssessmentsSettingResourceId = ServerVulnerabilityAssessmentsSettingResource.CreateResourceIdentifier(subscriptionId, settingKind);
            ServerVulnerabilityAssessmentsSettingResource serverVulnerabilityAssessmentsSetting = client.GetServerVulnerabilityAssessmentsSettingResource(serverVulnerabilityAssessmentsSettingResourceId);

            // invoke the operation
            ServerVulnerabilityAssessmentsSettingData data = new AzureServersSetting()
            {
                SelectedProvider = ServerVulnerabilityAssessmentsAzureSettingSelectedProvider.MdeTvm,
            };
            ArmOperation<ServerVulnerabilityAssessmentsSettingResource> lro = await serverVulnerabilityAssessmentsSetting.UpdateAsync(WaitUntil.Completed, data);
            ServerVulnerabilityAssessmentsSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServerVulnerabilityAssessmentsSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete the server vulnerability assessments setting of the kind settingKind from the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteTheServerVulnerabilityAssessmentsSettingOfTheKindSettingKindFromTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/DeleteServerVulnerabilityAssessmentsSetting_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessmentsSettings_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServerVulnerabilityAssessmentsSettingResource created on azure
            // for more information of creating ServerVulnerabilityAssessmentsSettingResource, please refer to the document of ServerVulnerabilityAssessmentsSettingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ServerVulnerabilityAssessmentsSettingKindName settingKind = ServerVulnerabilityAssessmentsSettingKindName.AzureServersSetting;
            ResourceIdentifier serverVulnerabilityAssessmentsSettingResourceId = ServerVulnerabilityAssessmentsSettingResource.CreateResourceIdentifier(subscriptionId, settingKind);
            ServerVulnerabilityAssessmentsSettingResource serverVulnerabilityAssessmentsSetting = client.GetServerVulnerabilityAssessmentsSettingResource(serverVulnerabilityAssessmentsSettingResourceId);

            // invoke the operation
            await serverVulnerabilityAssessmentsSetting.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
