// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_ServerVulnerabilityAssessmentsSettingCollection
    {
        // List the server vulnerability assessments settings set on the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListTheServerVulnerabilityAssessmentsSettingsSetOnTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/ListServerVulnerabilityAssessmentsSettings_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessmentsSettings_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // get the collection of this ServerVulnerabilityAssessmentsSettingResource
            ServerVulnerabilityAssessmentsSettingCollection collection = subscriptionResource.GetServerVulnerabilityAssessmentsSettings();

            // invoke the operation and iterate over the result
            await foreach (ServerVulnerabilityAssessmentsSettingResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ServerVulnerabilityAssessmentsSettingData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get the server vulnerability assessments setting of the kind settingKind that is set on the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheServerVulnerabilityAssessmentsSettingOfTheKindSettingKindThatIsSetOnTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/GetServerVulnerabilityAssessmentsSetting_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessmentsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // get the collection of this ServerVulnerabilityAssessmentsSettingResource
            ServerVulnerabilityAssessmentsSettingCollection collection = subscriptionResource.GetServerVulnerabilityAssessmentsSettings();

            // invoke the operation
            ServerVulnerabilityAssessmentsSettingKindName settingKind = ServerVulnerabilityAssessmentsSettingKindName.AzureServersSetting;
            ServerVulnerabilityAssessmentsSettingResource result = await collection.GetAsync(settingKind);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServerVulnerabilityAssessmentsSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get the server vulnerability assessments setting of the kind settingKind that is set on the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetTheServerVulnerabilityAssessmentsSettingOfTheKindSettingKindThatIsSetOnTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/GetServerVulnerabilityAssessmentsSetting_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessmentsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // get the collection of this ServerVulnerabilityAssessmentsSettingResource
            ServerVulnerabilityAssessmentsSettingCollection collection = subscriptionResource.GetServerVulnerabilityAssessmentsSettings();

            // invoke the operation
            ServerVulnerabilityAssessmentsSettingKindName settingKind = ServerVulnerabilityAssessmentsSettingKindName.AzureServersSetting;
            bool result = await collection.ExistsAsync(settingKind);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get the server vulnerability assessments setting of the kind settingKind that is set on the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetTheServerVulnerabilityAssessmentsSettingOfTheKindSettingKindThatIsSetOnTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/GetServerVulnerabilityAssessmentsSetting_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessmentsSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // get the collection of this ServerVulnerabilityAssessmentsSettingResource
            ServerVulnerabilityAssessmentsSettingCollection collection = subscriptionResource.GetServerVulnerabilityAssessmentsSettings();

            // invoke the operation
            ServerVulnerabilityAssessmentsSettingKindName settingKind = ServerVulnerabilityAssessmentsSettingKindName.AzureServersSetting;
            NullableResponse<ServerVulnerabilityAssessmentsSettingResource> response = await collection.GetIfExistsAsync(settingKind);
            ServerVulnerabilityAssessmentsSettingResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ServerVulnerabilityAssessmentsSettingData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Set a server vulnerability assessments setting of the kind settingKind on the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SetAServerVulnerabilityAssessmentsSettingOfTheKindSettingKindOnTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/PutServerVulnerabilityAssessmentsSetting_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessmentsSettings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // get the collection of this ServerVulnerabilityAssessmentsSettingResource
            ServerVulnerabilityAssessmentsSettingCollection collection = subscriptionResource.GetServerVulnerabilityAssessmentsSettings();

            // invoke the operation
            ServerVulnerabilityAssessmentsSettingKindName settingKind = ServerVulnerabilityAssessmentsSettingKindName.AzureServersSetting;
            ServerVulnerabilityAssessmentsSettingData data = new AzureServersSetting()
            {
                SelectedProvider = ServerVulnerabilityAssessmentsAzureSettingSelectedProvider.MdeTvm,
            };
            ArmOperation<ServerVulnerabilityAssessmentsSettingResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, settingKind, data);
            ServerVulnerabilityAssessmentsSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServerVulnerabilityAssessmentsSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
