// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_ServerVulnerabilityAssessmentResource
    {
        // Get a server vulnerability assessments onboarding status on a resource. Currently Microsoft.Security only supports the single 'default' resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServerVulnerabilityAssessmentsOnboardingStatusOnAResourceCurrentlyMicrosoftSecurityOnlySupportsTheSingleDefaultResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ServerVulnerabilityAssessments/GetServerVulnerabilityAssessments_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessment_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServerVulnerabilityAssessmentResource created on azure
            // for more information of creating ServerVulnerabilityAssessmentResource, please refer to the document of ServerVulnerabilityAssessmentResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            ResourceIdentifier serverVulnerabilityAssessmentResourceId = ServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceNamespace, resourceType, resourceName);
            ServerVulnerabilityAssessmentResource serverVulnerabilityAssessment = client.GetServerVulnerabilityAssessmentResource(serverVulnerabilityAssessmentResourceId);

            // invoke the operation
            ServerVulnerabilityAssessmentResource result = await serverVulnerabilityAssessment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a server vulnerability assessments on a resource. Only 'default' resource is supported. Once creating the resource, the server will be onboarded to vulnerability assessment by Microsoft.Security
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAServerVulnerabilityAssessmentsOnAResourceOnlyDefaultResourceIsSupportedOnceCreatingTheResourceTheServerWillBeOnboardedToVulnerabilityAssessmentByMicrosoftSecurity()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ServerVulnerabilityAssessments/CreateServerVulnerabilityAssessments_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessment_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServerVulnerabilityAssessmentResource created on azure
            // for more information of creating ServerVulnerabilityAssessmentResource, please refer to the document of ServerVulnerabilityAssessmentResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            ResourceIdentifier serverVulnerabilityAssessmentResourceId = ServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceNamespace, resourceType, resourceName);
            ServerVulnerabilityAssessmentResource serverVulnerabilityAssessment = client.GetServerVulnerabilityAssessmentResource(serverVulnerabilityAssessmentResourceId);

            // invoke the operation
            ArmOperation<ServerVulnerabilityAssessmentResource> lro = await serverVulnerabilityAssessment.UpdateAsync(WaitUntil.Completed);
            ServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a server vulnerability assessments on a resource. Only 'default' resource is supported. Once deleting, Microsoft.Security will not provide vulnerability assessment findings on the resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAServerVulnerabilityAssessmentsOnAResourceOnlyDefaultResourceIsSupportedOnceDeletingMicrosoftSecurityWillNotProvideVulnerabilityAssessmentFindingsOnTheResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ServerVulnerabilityAssessments/DeleteServerVulnerabilityAssessments_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessment_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServerVulnerabilityAssessmentResource created on azure
            // for more information of creating ServerVulnerabilityAssessmentResource, please refer to the document of ServerVulnerabilityAssessmentResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            ResourceIdentifier serverVulnerabilityAssessmentResourceId = ServerVulnerabilityAssessmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceNamespace, resourceType, resourceName);
            ServerVulnerabilityAssessmentResource serverVulnerabilityAssessment = client.GetServerVulnerabilityAssessmentResource(serverVulnerabilityAssessmentResourceId);

            // invoke the operation
            await serverVulnerabilityAssessment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
