// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_ServerVulnerabilityAssessmentCollection
    {
        // Get a list of server vulnerability assessments on a resource. Though this API returns a list, Currently Microsoft.Security only supports a single default type of server vulnerability assessment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetAListOfServerVulnerabilityAssessmentsOnAResourceThoughThisAPIReturnsAListCurrentlyMicrosoftSecurityOnlySupportsASingleDefaultTypeOfServerVulnerabilityAssessment()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ServerVulnerabilityAssessments/ListByExtendedResourceServerVulnerabilityAssessments_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessment_ListByExtendedResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ServerVulnerabilityAssessmentResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            ServerVulnerabilityAssessmentCollection collection = resourceGroupResource.GetServerVulnerabilityAssessments(resourceNamespace, resourceType, resourceName);

            // invoke the operation and iterate over the result
            await foreach (ServerVulnerabilityAssessmentResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ServerVulnerabilityAssessmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a server vulnerability assessments onboarding status on a resource. Currently Microsoft.Security only supports the single 'default' resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAServerVulnerabilityAssessmentsOnboardingStatusOnAResourceCurrentlyMicrosoftSecurityOnlySupportsTheSingleDefaultResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ServerVulnerabilityAssessments/GetServerVulnerabilityAssessments_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessment_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ServerVulnerabilityAssessmentResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            ServerVulnerabilityAssessmentCollection collection = resourceGroupResource.GetServerVulnerabilityAssessments(resourceNamespace, resourceType, resourceName);

            // invoke the operation
            ServerVulnerabilityAssessmentResource result = await collection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a server vulnerability assessments onboarding status on a resource. Currently Microsoft.Security only supports the single 'default' resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAServerVulnerabilityAssessmentsOnboardingStatusOnAResourceCurrentlyMicrosoftSecurityOnlySupportsTheSingleDefaultResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ServerVulnerabilityAssessments/GetServerVulnerabilityAssessments_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessment_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ServerVulnerabilityAssessmentResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            ServerVulnerabilityAssessmentCollection collection = resourceGroupResource.GetServerVulnerabilityAssessments(resourceNamespace, resourceType, resourceName);

            // invoke the operation
            bool result = await collection.ExistsAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a server vulnerability assessments onboarding status on a resource. Currently Microsoft.Security only supports the single 'default' resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAServerVulnerabilityAssessmentsOnboardingStatusOnAResourceCurrentlyMicrosoftSecurityOnlySupportsTheSingleDefaultResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ServerVulnerabilityAssessments/GetServerVulnerabilityAssessments_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessment_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ServerVulnerabilityAssessmentResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            ServerVulnerabilityAssessmentCollection collection = resourceGroupResource.GetServerVulnerabilityAssessments(resourceNamespace, resourceType, resourceName);

            // invoke the operation
            NullableResponse<ServerVulnerabilityAssessmentResource> response = await collection.GetIfExistsAsync();
            ServerVulnerabilityAssessmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ServerVulnerabilityAssessmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create a server vulnerability assessments on a resource. Only 'default' resource is supported. Once creating the resource, the server will be onboarded to vulnerability assessment by Microsoft.Security
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAServerVulnerabilityAssessmentsOnAResourceOnlyDefaultResourceIsSupportedOnceCreatingTheResourceTheServerWillBeOnboardedToVulnerabilityAssessmentByMicrosoftSecurity()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ServerVulnerabilityAssessments/CreateServerVulnerabilityAssessments_example.json
            // this example is just showing the usage of "ServerVulnerabilityAssessment_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ServerVulnerabilityAssessmentResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            ServerVulnerabilityAssessmentCollection collection = resourceGroupResource.GetServerVulnerabilityAssessments(resourceNamespace, resourceType, resourceName);

            // invoke the operation
            ArmOperation<ServerVulnerabilityAssessmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed);
            ServerVulnerabilityAssessmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServerVulnerabilityAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
