// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SecuritySubAssessmentResource
    {
        // Get security recommendation task from security data location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSecurityRecommendationTaskFromSecurityDataLocation()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2019-01-01-preview/examples/SubAssessments/GetSubAssessment_example.json
            // this example is just showing the usage of "SubAssessments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecuritySubAssessmentResource created on azure
            // for more information of creating SecuritySubAssessmentResource, please refer to the document of SecuritySubAssessmentResource
            string scope = "subscriptions/212f9889-769e-45ae-ab43-6da33674bd26/resourceGroups/DEMORG/providers/Microsoft.Compute/virtualMachines/vm2";
            string assessmentName = "1195afff-c881-495e-9bc5-1486211ae03f";
            string subAssessmentName = "95f7da9c-a2a4-1322-0758-fcd24ef09b85";
            ResourceIdentifier securitySubAssessmentResourceId = SecuritySubAssessmentResource.CreateResourceIdentifier(scope, assessmentName, subAssessmentName);
            SecuritySubAssessmentResource securitySubAssessment = client.GetSecuritySubAssessmentResource(securitySubAssessmentResourceId);

            // invoke the operation
            SecuritySubAssessmentResource result = await securitySubAssessment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecuritySubAssessmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
