// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SecuritySettingResource
    {
        // Get a setting on subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASettingOnSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2022-05-01/examples/Settings/GetSetting_example.json
            // this example is just showing the usage of "Settings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecuritySettingResource created on azure
            // for more information of creating SecuritySettingResource, please refer to the document of SecuritySettingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            SecuritySettingName settingName = SecuritySettingName.Wdatp;
            ResourceIdentifier securitySettingResourceId = SecuritySettingResource.CreateResourceIdentifier(subscriptionId, settingName);
            SecuritySettingResource securitySetting = client.GetSecuritySettingResource(securitySettingResourceId);

            // invoke the operation
            SecuritySettingResource result = await securitySetting.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecuritySettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a setting for subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateASettingForSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2022-05-01/examples/Settings/UpdateSetting_example.json
            // this example is just showing the usage of "Settings_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecuritySettingResource created on azure
            // for more information of creating SecuritySettingResource, please refer to the document of SecuritySettingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            SecuritySettingName settingName = SecuritySettingName.Wdatp;
            ResourceIdentifier securitySettingResourceId = SecuritySettingResource.CreateResourceIdentifier(subscriptionId, settingName);
            SecuritySettingResource securitySetting = client.GetSecuritySettingResource(securitySettingResourceId);

            // invoke the operation
            SecuritySettingData data = new DataExportSettings()
            {
                IsEnabled = true,
            };
            ArmOperation<SecuritySettingResource> lro = await securitySetting.UpdateAsync(WaitUntil.Completed, data);
            SecuritySettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecuritySettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
