// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SecurityOperatorCollection
    {
        // List SecurityOperators
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListSecurityOperators()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-01-01-preview/examples/SecurityOperators/ListSecurityOperators_example.json
            // this example is just showing the usage of "SecurityOperators_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCenterPricingResource created on azure
            // for more information of creating SecurityCenterPricingResource, please refer to the document of SecurityCenterPricingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string pricingName = "CloudPosture";
            ResourceIdentifier securityCenterPricingResourceId = SecurityCenterPricingResource.CreateResourceIdentifier(subscriptionId, pricingName);
            SecurityCenterPricingResource securityCenterPricing = client.GetSecurityCenterPricingResource(securityCenterPricingResourceId);

            // get the collection of this SecurityOperatorResource
            SecurityOperatorCollection collection = securityCenterPricing.GetSecurityOperators();

            // invoke the operation and iterate over the result
            await foreach (SecurityOperatorResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SecurityOperatorData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a specific security operator by scope and securityOperatorName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASpecificSecurityOperatorByScopeAndSecurityOperatorName()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-01-01-preview/examples/SecurityOperators/GetSecurityOperatorByName_example.json
            // this example is just showing the usage of "SecurityOperators_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCenterPricingResource created on azure
            // for more information of creating SecurityCenterPricingResource, please refer to the document of SecurityCenterPricingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string pricingName = "CloudPosture";
            ResourceIdentifier securityCenterPricingResourceId = SecurityCenterPricingResource.CreateResourceIdentifier(subscriptionId, pricingName);
            SecurityCenterPricingResource securityCenterPricing = client.GetSecurityCenterPricingResource(securityCenterPricingResourceId);

            // get the collection of this SecurityOperatorResource
            SecurityOperatorCollection collection = securityCenterPricing.GetSecurityOperators();

            // invoke the operation
            string securityOperatorName = "DefenderCSPMSecurityOperator";
            SecurityOperatorResource result = await collection.GetAsync(securityOperatorName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityOperatorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a specific security operator by scope and securityOperatorName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetASpecificSecurityOperatorByScopeAndSecurityOperatorName()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-01-01-preview/examples/SecurityOperators/GetSecurityOperatorByName_example.json
            // this example is just showing the usage of "SecurityOperators_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCenterPricingResource created on azure
            // for more information of creating SecurityCenterPricingResource, please refer to the document of SecurityCenterPricingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string pricingName = "CloudPosture";
            ResourceIdentifier securityCenterPricingResourceId = SecurityCenterPricingResource.CreateResourceIdentifier(subscriptionId, pricingName);
            SecurityCenterPricingResource securityCenterPricing = client.GetSecurityCenterPricingResource(securityCenterPricingResourceId);

            // get the collection of this SecurityOperatorResource
            SecurityOperatorCollection collection = securityCenterPricing.GetSecurityOperators();

            // invoke the operation
            string securityOperatorName = "DefenderCSPMSecurityOperator";
            bool result = await collection.ExistsAsync(securityOperatorName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a specific security operator by scope and securityOperatorName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetASpecificSecurityOperatorByScopeAndSecurityOperatorName()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-01-01-preview/examples/SecurityOperators/GetSecurityOperatorByName_example.json
            // this example is just showing the usage of "SecurityOperators_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCenterPricingResource created on azure
            // for more information of creating SecurityCenterPricingResource, please refer to the document of SecurityCenterPricingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string pricingName = "CloudPosture";
            ResourceIdentifier securityCenterPricingResourceId = SecurityCenterPricingResource.CreateResourceIdentifier(subscriptionId, pricingName);
            SecurityCenterPricingResource securityCenterPricing = client.GetSecurityCenterPricingResource(securityCenterPricingResourceId);

            // get the collection of this SecurityOperatorResource
            SecurityOperatorCollection collection = securityCenterPricing.GetSecurityOperators();

            // invoke the operation
            string securityOperatorName = "DefenderCSPMSecurityOperator";
            NullableResponse<SecurityOperatorResource> response = await collection.GetIfExistsAsync(securityOperatorName);
            SecurityOperatorResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SecurityOperatorData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create a security operator on the given scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateASecurityOperatorOnTheGivenScope()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-01-01-preview/examples/SecurityOperators/PutSecurityOperatorByName_example.json
            // this example is just showing the usage of "SecurityOperators_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCenterPricingResource created on azure
            // for more information of creating SecurityCenterPricingResource, please refer to the document of SecurityCenterPricingResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string pricingName = "CloudPosture";
            ResourceIdentifier securityCenterPricingResourceId = SecurityCenterPricingResource.CreateResourceIdentifier(subscriptionId, pricingName);
            SecurityCenterPricingResource securityCenterPricing = client.GetSecurityCenterPricingResource(securityCenterPricingResourceId);

            // get the collection of this SecurityOperatorResource
            SecurityOperatorCollection collection = securityCenterPricing.GetSecurityOperators();

            // invoke the operation
            string securityOperatorName = "DefenderCSPMSecurityOperator";
            ArmOperation<SecurityOperatorResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, securityOperatorName);
            SecurityOperatorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityOperatorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
