// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SecurityConnectorGitLabGroupResource
    {
        // Get_GitLabGroups
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetGitLabGroups()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-09-01-preview/examples/SecurityConnectorsDevOps/GetGitLabGroups_example.json
            // this example is just showing the usage of "GitLabGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityConnectorGitLabGroupResource created on azure
            // for more information of creating SecurityConnectorGitLabGroupResource, please refer to the document of SecurityConnectorGitLabGroupResource
            string subscriptionId = "0806e1cd-cfda-4ff8-b99c-2b0af42cffd3";
            string resourceGroupName = "myRg";
            string securityConnectorName = "mySecurityConnectorName";
            string groupFQName = "myGitLabGroup$mySubGroup";
            ResourceIdentifier securityConnectorGitLabGroupResourceId = SecurityConnectorGitLabGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName, groupFQName);
            SecurityConnectorGitLabGroupResource securityConnectorGitLabGroup = client.GetSecurityConnectorGitLabGroupResource(securityConnectorGitLabGroupResourceId);

            // invoke the operation
            SecurityConnectorGitLabGroupResource result = await securityConnectorGitLabGroup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityConnectorGitLabGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
