// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SecurityConnectorApplicationCollection
    {
        // List security applications by security connector level scope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListSecurityApplicationsBySecurityConnectorLevelScope()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2022-07-01-preview/examples/Applications/ListBySecurityConnectorApplications_example.json
            // this example is just showing the usage of "SecurityConnectorApplications_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityConnectorResource created on azure
            // for more information of creating SecurityConnectorResource, please refer to the document of SecurityConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "gcpResourceGroup";
            string securityConnectorName = "gcpconnector";
            ResourceIdentifier securityConnectorResourceId = SecurityConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName);
            SecurityConnectorResource securityConnector = client.GetSecurityConnectorResource(securityConnectorResourceId);

            // get the collection of this SecurityConnectorApplicationResource
            SecurityConnectorApplicationCollection collection = securityConnector.GetSecurityConnectorApplications();

            // invoke the operation and iterate over the result
            await foreach (SecurityConnectorApplicationResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SecurityApplicationData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get security applications by specific applicationId
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSecurityApplicationsBySpecificApplicationId()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2022-07-01-preview/examples/Applications/GetSecurityConnectorApplication_example.json
            // this example is just showing the usage of "SecurityConnectorApplications_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityConnectorResource created on azure
            // for more information of creating SecurityConnectorResource, please refer to the document of SecurityConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "gcpResourceGroup";
            string securityConnectorName = "gcpconnector";
            ResourceIdentifier securityConnectorResourceId = SecurityConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName);
            SecurityConnectorResource securityConnector = client.GetSecurityConnectorResource(securityConnectorResourceId);

            // get the collection of this SecurityConnectorApplicationResource
            SecurityConnectorApplicationCollection collection = securityConnector.GetSecurityConnectorApplications();

            // invoke the operation
            string applicationId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8";
            SecurityConnectorApplicationResource result = await collection.GetAsync(applicationId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityApplicationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get security applications by specific applicationId
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetSecurityApplicationsBySpecificApplicationId()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2022-07-01-preview/examples/Applications/GetSecurityConnectorApplication_example.json
            // this example is just showing the usage of "SecurityConnectorApplications_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityConnectorResource created on azure
            // for more information of creating SecurityConnectorResource, please refer to the document of SecurityConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "gcpResourceGroup";
            string securityConnectorName = "gcpconnector";
            ResourceIdentifier securityConnectorResourceId = SecurityConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName);
            SecurityConnectorResource securityConnector = client.GetSecurityConnectorResource(securityConnectorResourceId);

            // get the collection of this SecurityConnectorApplicationResource
            SecurityConnectorApplicationCollection collection = securityConnector.GetSecurityConnectorApplications();

            // invoke the operation
            string applicationId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8";
            bool result = await collection.ExistsAsync(applicationId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get security applications by specific applicationId
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetSecurityApplicationsBySpecificApplicationId()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2022-07-01-preview/examples/Applications/GetSecurityConnectorApplication_example.json
            // this example is just showing the usage of "SecurityConnectorApplications_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityConnectorResource created on azure
            // for more information of creating SecurityConnectorResource, please refer to the document of SecurityConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "gcpResourceGroup";
            string securityConnectorName = "gcpconnector";
            ResourceIdentifier securityConnectorResourceId = SecurityConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName);
            SecurityConnectorResource securityConnector = client.GetSecurityConnectorResource(securityConnectorResourceId);

            // get the collection of this SecurityConnectorApplicationResource
            SecurityConnectorApplicationCollection collection = securityConnector.GetSecurityConnectorApplications();

            // invoke the operation
            string applicationId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8";
            NullableResponse<SecurityConnectorApplicationResource> response = await collection.GetIfExistsAsync(applicationId);
            SecurityConnectorApplicationResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SecurityApplicationData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create Application
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateApplication()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2022-07-01-preview/examples/Applications/PutSecurityConnectorApplication_example.json
            // this example is just showing the usage of "SecurityConnectorApplications_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityConnectorResource created on azure
            // for more information of creating SecurityConnectorResource, please refer to the document of SecurityConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "gcpResourceGroup";
            string securityConnectorName = "gcpconnector";
            ResourceIdentifier securityConnectorResourceId = SecurityConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName);
            SecurityConnectorResource securityConnector = client.GetSecurityConnectorResource(securityConnectorResourceId);

            // get the collection of this SecurityConnectorApplicationResource
            SecurityConnectorApplicationCollection collection = securityConnector.GetSecurityConnectorApplications();

            // invoke the operation
            string applicationId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8";
            SecurityApplicationData data = new SecurityApplicationData()
            {
                DisplayName = "GCP Admin's application",
                Description = "An application on critical GCP recommendations",
                SourceResourceType = ApplicationSourceResourceType.Assessments,
                ConditionSets =
{
BinaryData.FromObjectAsJson(new Dictionary<string, object>()
{
["conditions"] = new object[] { new Dictionary<string, object>()
{
["operator"] = "contains",
["property"] = "$.Id",
["value"] = "-prod-"} }})
},
            };
            ArmOperation<SecurityConnectorApplicationResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, applicationId, data);
            SecurityConnectorApplicationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityApplicationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
