// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SecurityCloudConnectorResource
    {
        // Details of a specific cloud account connector
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_DetailsOfASpecificCloudAccountConnector()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/GetConnectorSubscription_example.json
            // this example is just showing the usage of "Connectors_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCloudConnectorResource created on azure
            // for more information of creating SecurityCloudConnectorResource, please refer to the document of SecurityCloudConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string connectorName = "aws_dev1";
            ResourceIdentifier securityCloudConnectorResourceId = SecurityCloudConnectorResource.CreateResourceIdentifier(subscriptionId, connectorName);
            SecurityCloudConnectorResource securityCloudConnector = client.GetSecurityCloudConnectorResource(securityCloudConnectorResourceId);

            // invoke the operation
            SecurityCloudConnectorResource result = await securityCloudConnector.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityCloudConnectorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AwsAssumeRole - Create a cloud account connector for a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AwsAssumeRoleCreateACloudAccountConnectorForASubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/CreateUpdateAwsAssumeRoleConnectorSubscription_example.json
            // this example is just showing the usage of "Connectors_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCloudConnectorResource created on azure
            // for more information of creating SecurityCloudConnectorResource, please refer to the document of SecurityCloudConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string connectorName = "aws_dev2";
            ResourceIdentifier securityCloudConnectorResourceId = SecurityCloudConnectorResource.CreateResourceIdentifier(subscriptionId, connectorName);
            SecurityCloudConnectorResource securityCloudConnector = client.GetSecurityCloudConnectorResource(securityCloudConnectorResourceId);

            // invoke the operation
            SecurityCloudConnectorData data = new SecurityCloudConnectorData()
            {
                HybridComputeSettings = new HybridComputeSettingsProperties(AutoProvisionState.On)
                {
                    ResourceGroupName = "AwsConnectorRG",
                    Region = "West US 2",
                    ProxyServer = new ProxyServerProperties()
                    {
                        IP = "167.220.197.140",
                        Port = "34",
                    },
                    ServicePrincipal = new ServicePrincipalProperties()
                    {
                        ApplicationId = Guid.Parse("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
                        Secret = "<secret>",
                    },
                },
                AuthenticationDetails = new AwsAssumeRoleAuthenticationDetailsProperties("arn:aws:iam::81231569658:role/AscConnector", Guid.Parse("20ff7fc3-e762-44dd-bd96-b71116dcdc23")),
            };
            ArmOperation<SecurityCloudConnectorResource> lro = await securityCloudConnector.UpdateAsync(WaitUntil.Completed, data);
            SecurityCloudConnectorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityCloudConnectorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AwsCred - Create a cloud account connector for a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AwsCredCreateACloudAccountConnectorForASubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/CreateUpdateAwsCredConnectorSubscription_example.json
            // this example is just showing the usage of "Connectors_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCloudConnectorResource created on azure
            // for more information of creating SecurityCloudConnectorResource, please refer to the document of SecurityCloudConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string connectorName = "aws_dev1";
            ResourceIdentifier securityCloudConnectorResourceId = SecurityCloudConnectorResource.CreateResourceIdentifier(subscriptionId, connectorName);
            SecurityCloudConnectorResource securityCloudConnector = client.GetSecurityCloudConnectorResource(securityCloudConnectorResourceId);

            // invoke the operation
            SecurityCloudConnectorData data = new SecurityCloudConnectorData()
            {
                HybridComputeSettings = new HybridComputeSettingsProperties(AutoProvisionState.On)
                {
                    ResourceGroupName = "AwsConnectorRG",
                    Region = "West US 2",
                    ProxyServer = new ProxyServerProperties()
                    {
                        IP = "167.220.197.140",
                        Port = "34",
                    },
                    ServicePrincipal = new ServicePrincipalProperties()
                    {
                        ApplicationId = Guid.Parse("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
                        Secret = "<secret>",
                    },
                },
                AuthenticationDetails = new AwsCredsAuthenticationDetailsProperties("AKIARPZCNODDNAEQFSOE", "<awsSecretAccessKey>"),
            };
            ArmOperation<SecurityCloudConnectorResource> lro = await securityCloudConnector.UpdateAsync(WaitUntil.Completed, data);
            SecurityCloudConnectorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityCloudConnectorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // gcpCredentials - Create a cloud account connector for a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_GcpCredentialsCreateACloudAccountConnectorForASubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/CreateUpdateGcpCredentialsConnectorSubscription_example.json
            // this example is just showing the usage of "Connectors_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCloudConnectorResource created on azure
            // for more information of creating SecurityCloudConnectorResource, please refer to the document of SecurityCloudConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string connectorName = "gcp_dev";
            ResourceIdentifier securityCloudConnectorResourceId = SecurityCloudConnectorResource.CreateResourceIdentifier(subscriptionId, connectorName);
            SecurityCloudConnectorResource securityCloudConnector = client.GetSecurityCloudConnectorResource(securityCloudConnectorResourceId);

            // invoke the operation
            SecurityCloudConnectorData data = new SecurityCloudConnectorData()
            {
                HybridComputeSettings = new HybridComputeSettingsProperties(AutoProvisionState.Off),
                AuthenticationDetails = new GcpCredentialsDetailsProperties("AscDemoOrg", "service_account", "asc-project-1234", "6efg587hra2568as34d22326b044cc20dc2af", "******", "asc-135@asc-project-1234.iam.gserviceaccount.com", "105889053725632919854", new Uri("https://accounts.google.com/o/oauth2/auth"), new Uri("https://oauth2.googleapis.com/token"), new Uri("https://www.googleapis.com/oauth2/v1/certs"), new Uri("https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com")),
            };
            ArmOperation<SecurityCloudConnectorResource> lro = await securityCloudConnector.UpdateAsync(WaitUntil.Completed, data);
            SecurityCloudConnectorResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityCloudConnectorData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a cloud account connector from a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteACloudAccountConnectorFromASubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/DeleteConnectorSubscription_example.json
            // this example is just showing the usage of "Connectors_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCloudConnectorResource created on azure
            // for more information of creating SecurityCloudConnectorResource, please refer to the document of SecurityCloudConnectorResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string connectorName = "aws_dev1";
            ResourceIdentifier securityCloudConnectorResourceId = SecurityCloudConnectorResource.CreateResourceIdentifier(subscriptionId, connectorName);
            SecurityCloudConnectorResource securityCloudConnector = client.GetSecurityCloudConnectorResource(securityCloudConnectorResourceId);

            // invoke the operation
            await securityCloudConnector.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
