// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SecurityCenterApiCollectionResource
    {
        // Gets a list of API collections within a subscription that have been onboarded to Microsoft Defender for APIs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSecurityCenterApiCollections_GetsAListOfAPICollectionsWithinASubscriptionThatHaveBeenOnboardedToMicrosoftDefenderForAPIs()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-11-15/examples/ApiCollections/APICollections_ListBySubscription_example.json
            // this example is just showing the usage of "APICollections_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (SecurityCenterApiCollectionResource item in subscriptionResource.GetSecurityCenterApiCollectionsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SecurityCenterApiCollectionData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets a list of API collections within a resource group that have been onboarded to Microsoft Defender for APIs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSecurityCenterApiCollections_GetsAListOfAPICollectionsWithinAResourceGroupThatHaveBeenOnboardedToMicrosoftDefenderForAPIs()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-11-15/examples/ApiCollections/APICollections_ListByResourceGroup_example.json
            // this example is just showing the usage of "APICollections_ListByResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // invoke the operation and iterate over the result
            await foreach (SecurityCenterApiCollectionResource item in resourceGroupResource.GetSecurityCenterApiCollectionsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SecurityCenterApiCollectionData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets an Azure API Management API if it has been onboarded to Microsoft Defender for APIs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAnAzureAPIManagementAPIIfItHasBeenOnboardedToMicrosoftDefenderForAPIs()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-11-15/examples/ApiCollections/APICollections_GetByAzureApiManagementService_example.json
            // this example is just showing the usage of "APICollections_GetByAzureApiManagementService" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCenterApiCollectionResource created on azure
            // for more information of creating SecurityCenterApiCollectionResource, please refer to the document of SecurityCenterApiCollectionResource
            string subscriptionId = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string apiId = "echo-api";
            ResourceIdentifier securityCenterApiCollectionResourceId = SecurityCenterApiCollectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, apiId);
            SecurityCenterApiCollectionResource securityCenterApiCollection = client.GetSecurityCenterApiCollectionResource(securityCenterApiCollectionResourceId);

            // invoke the operation
            SecurityCenterApiCollectionResource result = await securityCenterApiCollection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityCenterApiCollectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Onboard an Azure API Management API to Microsoft Defender for APIs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_OnboardAnAzureAPIManagementAPIToMicrosoftDefenderForAPIs()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-11-15/examples/ApiCollections/APICollections_OnboardAzureApiManagementApi_example.json
            // this example is just showing the usage of "APICollections_OnboardAzureApiManagementApi" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCenterApiCollectionResource created on azure
            // for more information of creating SecurityCenterApiCollectionResource, please refer to the document of SecurityCenterApiCollectionResource
            string subscriptionId = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string apiId = "echo-api";
            ResourceIdentifier securityCenterApiCollectionResourceId = SecurityCenterApiCollectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, apiId);
            SecurityCenterApiCollectionResource securityCenterApiCollection = client.GetSecurityCenterApiCollectionResource(securityCenterApiCollectionResourceId);

            // invoke the operation
            ArmOperation<SecurityCenterApiCollectionResource> lro = await securityCenterApiCollection.UpdateAsync(WaitUntil.Completed);
            SecurityCenterApiCollectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityCenterApiCollectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Offboard an Azure API Management API from Microsoft Defender for APIs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_OffboardAnAzureAPIManagementAPIFromMicrosoftDefenderForAPIs()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2023-11-15/examples/ApiCollections/APICollections_OffboardAzureApiManagementApi_example.json
            // this example is just showing the usage of "APICollections_OffboardAzureApiManagementApi" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecurityCenterApiCollectionResource created on azure
            // for more information of creating SecurityCenterApiCollectionResource, please refer to the document of SecurityCenterApiCollectionResource
            string subscriptionId = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string apiId = "echo-api";
            ResourceIdentifier securityCenterApiCollectionResourceId = SecurityCenterApiCollectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, apiId);
            SecurityCenterApiCollectionResource securityCenterApiCollection = client.GetSecurityCenterApiCollectionResource(securityCenterApiCollectionResourceId);

            // invoke the operation
            await securityCenterApiCollection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
