// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_SecureScoreResource
    {
        // Get single secure score
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSingleSecureScore()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/secureScores/GetSecureScoresSingle_example.json
            // this example is just showing the usage of "SecureScores_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecureScoreResource created on azure
            // for more information of creating SecureScoreResource, please refer to the document of SecureScoreResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string secureScoreName = "ascScore";
            ResourceIdentifier secureScoreResourceId = SecureScoreResource.CreateResourceIdentifier(subscriptionId, secureScoreName);
            SecureScoreResource secureScore = client.GetSecureScoreResource(secureScoreResourceId);

            // invoke the operation
            SecureScoreResource result = await secureScore.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecureScoreData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get security controls and their current score for the specified initiative
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSecureScoreControls_GetSecurityControlsAndTheirCurrentScoreForTheSpecifiedInitiative()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/secureScores/ListSecureScoreControlsForName_builtin_example.json
            // this example is just showing the usage of "SecureScoreControls_ListBySecureScore" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecureScoreResource created on azure
            // for more information of creating SecureScoreResource, please refer to the document of SecureScoreResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string secureScoreName = "ascScore";
            ResourceIdentifier secureScoreResourceId = SecureScoreResource.CreateResourceIdentifier(subscriptionId, secureScoreName);
            SecureScoreResource secureScore = client.GetSecureScoreResource(secureScoreResourceId);

            // invoke the operation and iterate over the result
            await foreach (SecureScoreControlDetails item in secureScore.GetSecureScoreControlsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get security controls and their current score for the specified initiative with the expand parameter
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSecureScoreControls_GetSecurityControlsAndTheirCurrentScoreForTheSpecifiedInitiativeWithTheExpandParameter()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/secureScores/ListSecureScoreControlsForNameWithExpand_builtin_example.json
            // this example is just showing the usage of "SecureScoreControls_ListBySecureScore" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SecureScoreResource created on azure
            // for more information of creating SecureScoreResource, please refer to the document of SecureScoreResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string secureScoreName = "ascScore";
            ResourceIdentifier secureScoreResourceId = SecureScoreResource.CreateResourceIdentifier(subscriptionId, secureScoreName);
            SecureScoreResource secureScore = client.GetSecureScoreResource(secureScoreResourceId);

            // invoke the operation and iterate over the result
            SecurityScoreODataExpand? expand = SecurityScoreODataExpand.Definition;
            await foreach (SecureScoreControlDetails item in secureScore.GetSecureScoreControlsAsync(expand: expand))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
