// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_ResourceGroupSecurityAlertResource
    {
        // Get security alert on a resource group from a security data location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSecurityAlertOnAResourceGroupFromASecurityDataLocation()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/GetAlertResourceGroupLocation_example.json
            // this example is just showing the usage of "Alerts_GetResourceGroupLevel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupSecurityAlertResource created on azure
            // for more information of creating ResourceGroupSecurityAlertResource, please refer to the document of ResourceGroupSecurityAlertResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "myRg1";
            AzureLocation ascLocation = new AzureLocation("westeurope");
            string alertName = "2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a";
            ResourceIdentifier resourceGroupSecurityAlertResourceId = ResourceGroupSecurityAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ascLocation, alertName);
            ResourceGroupSecurityAlertResource resourceGroupSecurityAlert = client.GetResourceGroupSecurityAlertResource(resourceGroupSecurityAlertResourceId);

            // invoke the operation
            ResourceGroupSecurityAlertResource result = await resourceGroupSecurityAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SecurityAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update security alert state on a resource group from a security data location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Resolve_UpdateSecurityAlertStateOnAResourceGroupFromASecurityDataLocation()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertResourceGroupLocation_resolve_example.json
            // this example is just showing the usage of "Alerts_UpdateResourceGroupLevelStateToResolve" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupSecurityAlertResource created on azure
            // for more information of creating ResourceGroupSecurityAlertResource, please refer to the document of ResourceGroupSecurityAlertResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "myRg2";
            AzureLocation ascLocation = new AzureLocation("westeurope");
            string alertName = "2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22";
            ResourceIdentifier resourceGroupSecurityAlertResourceId = ResourceGroupSecurityAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ascLocation, alertName);
            ResourceGroupSecurityAlertResource resourceGroupSecurityAlert = client.GetResourceGroupSecurityAlertResource(resourceGroupSecurityAlertResourceId);

            // invoke the operation
            await resourceGroupSecurityAlert.ResolveAsync();

            Console.WriteLine($"Succeeded");
        }

        // Update security alert state on a resource group from a security data location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Dismiss_UpdateSecurityAlertStateOnAResourceGroupFromASecurityDataLocation()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertResourceGroupLocation_dismiss_example.json
            // this example is just showing the usage of "Alerts_UpdateResourceGroupLevelStateToDismiss" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupSecurityAlertResource created on azure
            // for more information of creating ResourceGroupSecurityAlertResource, please refer to the document of ResourceGroupSecurityAlertResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "myRg2";
            AzureLocation ascLocation = new AzureLocation("westeurope");
            string alertName = "2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22";
            ResourceIdentifier resourceGroupSecurityAlertResourceId = ResourceGroupSecurityAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ascLocation, alertName);
            ResourceGroupSecurityAlertResource resourceGroupSecurityAlert = client.GetResourceGroupSecurityAlertResource(resourceGroupSecurityAlertResourceId);

            // invoke the operation
            await resourceGroupSecurityAlert.DismissAsync();

            Console.WriteLine($"Succeeded");
        }

        // Update security alert state on a resource group from a security data location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Activate_UpdateSecurityAlertStateOnAResourceGroupFromASecurityDataLocation()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertResourceGroupLocation_activate_example.json
            // this example is just showing the usage of "Alerts_UpdateResourceGroupLevelStateToActivate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupSecurityAlertResource created on azure
            // for more information of creating ResourceGroupSecurityAlertResource, please refer to the document of ResourceGroupSecurityAlertResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "myRg2";
            AzureLocation ascLocation = new AzureLocation("westeurope");
            string alertName = "2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22";
            ResourceIdentifier resourceGroupSecurityAlertResourceId = ResourceGroupSecurityAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ascLocation, alertName);
            ResourceGroupSecurityAlertResource resourceGroupSecurityAlert = client.GetResourceGroupSecurityAlertResource(resourceGroupSecurityAlertResourceId);

            // invoke the operation
            await resourceGroupSecurityAlert.ActivateAsync();

            Console.WriteLine($"Succeeded");
        }

        // Update security alert state on a resource group from a security data location
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateSatateToInProgress_UpdateSecurityAlertStateOnAResourceGroupFromASecurityDataLocation()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertResourceGroupLocation_inProgress_example.json
            // this example is just showing the usage of "Alerts_UpdateResourceGroupLevelStateToInProgress" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupSecurityAlertResource created on azure
            // for more information of creating ResourceGroupSecurityAlertResource, please refer to the document of ResourceGroupSecurityAlertResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "myRg2";
            AzureLocation ascLocation = new AzureLocation("westeurope");
            string alertName = "2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22";
            ResourceIdentifier resourceGroupSecurityAlertResourceId = ResourceGroupSecurityAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ascLocation, alertName);
            ResourceGroupSecurityAlertResource resourceGroupSecurityAlert = client.GetResourceGroupSecurityAlertResource(resourceGroupSecurityAlertResourceId);

            // invoke the operation
            await resourceGroupSecurityAlert.UpdateSatateToInProgressAsync();

            Console.WriteLine($"Succeeded");
        }
    }
}
