// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_DevOpsRepositoryCollection
    {
        // List_AzureDevOpsRepos
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAzureDevOpsRepos()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-09-01-preview/examples/SecurityConnectorsDevOps/ListAzureDevOpsRepos_example.json
            // this example is just showing the usage of "AzureDevOpsRepos_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsProjectResource created on azure
            // for more information of creating DevOpsProjectResource, please refer to the document of DevOpsProjectResource
            string subscriptionId = "0806e1cd-cfda-4ff8-b99c-2b0af42cffd3";
            string resourceGroupName = "myRg";
            string securityConnectorName = "mySecurityConnectorName";
            string orgName = "myAzDevOpsOrg";
            string projectName = "myAzDevOpsProject";
            ResourceIdentifier devOpsProjectResourceId = DevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName, orgName, projectName);
            DevOpsProjectResource devOpsProject = client.GetDevOpsProjectResource(devOpsProjectResourceId);

            // get the collection of this DevOpsRepositoryResource
            DevOpsRepositoryCollection collection = devOpsProject.GetDevOpsRepositories();

            // invoke the operation and iterate over the result
            await foreach (DevOpsRepositoryResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DevOpsRepositoryData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get_AzureDevOpsRepos
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAzureDevOpsRepos()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-09-01-preview/examples/SecurityConnectorsDevOps/GetAzureDevOpsRepos_example.json
            // this example is just showing the usage of "AzureDevOpsRepos_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsProjectResource created on azure
            // for more information of creating DevOpsProjectResource, please refer to the document of DevOpsProjectResource
            string subscriptionId = "0806e1cd-cfda-4ff8-b99c-2b0af42cffd3";
            string resourceGroupName = "myRg";
            string securityConnectorName = "mySecurityConnectorName";
            string orgName = "myAzDevOpsOrg";
            string projectName = "myAzDevOpsProject";
            ResourceIdentifier devOpsProjectResourceId = DevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName, orgName, projectName);
            DevOpsProjectResource devOpsProject = client.GetDevOpsProjectResource(devOpsProjectResourceId);

            // get the collection of this DevOpsRepositoryResource
            DevOpsRepositoryCollection collection = devOpsProject.GetDevOpsRepositories();

            // invoke the operation
            string repoName = "myAzDevOpsRepo";
            DevOpsRepositoryResource result = await collection.GetAsync(repoName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevOpsRepositoryData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get_AzureDevOpsRepos
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAzureDevOpsRepos()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-09-01-preview/examples/SecurityConnectorsDevOps/GetAzureDevOpsRepos_example.json
            // this example is just showing the usage of "AzureDevOpsRepos_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsProjectResource created on azure
            // for more information of creating DevOpsProjectResource, please refer to the document of DevOpsProjectResource
            string subscriptionId = "0806e1cd-cfda-4ff8-b99c-2b0af42cffd3";
            string resourceGroupName = "myRg";
            string securityConnectorName = "mySecurityConnectorName";
            string orgName = "myAzDevOpsOrg";
            string projectName = "myAzDevOpsProject";
            ResourceIdentifier devOpsProjectResourceId = DevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName, orgName, projectName);
            DevOpsProjectResource devOpsProject = client.GetDevOpsProjectResource(devOpsProjectResourceId);

            // get the collection of this DevOpsRepositoryResource
            DevOpsRepositoryCollection collection = devOpsProject.GetDevOpsRepositories();

            // invoke the operation
            string repoName = "myAzDevOpsRepo";
            bool result = await collection.ExistsAsync(repoName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get_AzureDevOpsRepos
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAzureDevOpsRepos()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-09-01-preview/examples/SecurityConnectorsDevOps/GetAzureDevOpsRepos_example.json
            // this example is just showing the usage of "AzureDevOpsRepos_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsProjectResource created on azure
            // for more information of creating DevOpsProjectResource, please refer to the document of DevOpsProjectResource
            string subscriptionId = "0806e1cd-cfda-4ff8-b99c-2b0af42cffd3";
            string resourceGroupName = "myRg";
            string securityConnectorName = "mySecurityConnectorName";
            string orgName = "myAzDevOpsOrg";
            string projectName = "myAzDevOpsProject";
            ResourceIdentifier devOpsProjectResourceId = DevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName, orgName, projectName);
            DevOpsProjectResource devOpsProject = client.GetDevOpsProjectResource(devOpsProjectResourceId);

            // get the collection of this DevOpsRepositoryResource
            DevOpsRepositoryCollection collection = devOpsProject.GetDevOpsRepositories();

            // invoke the operation
            string repoName = "myAzDevOpsRepo";
            NullableResponse<DevOpsRepositoryResource> response = await collection.GetIfExistsAsync(repoName);
            DevOpsRepositoryResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DevOpsRepositoryData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // CreateOrUpdate_AzureDevOpsRepos
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAzureDevOpsRepos()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2023-09-01-preview/examples/SecurityConnectorsDevOps/CreateOrUpdateAzureDevOpsRepos_example.json
            // this example is just showing the usage of "AzureDevOpsRepos_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevOpsProjectResource created on azure
            // for more information of creating DevOpsProjectResource, please refer to the document of DevOpsProjectResource
            string subscriptionId = "0806e1cd-cfda-4ff8-b99c-2b0af42cffd3";
            string resourceGroupName = "myRg";
            string securityConnectorName = "mySecurityConnectorName";
            string orgName = "myAzDevOpsOrg";
            string projectName = "myAzDevOpsProject";
            ResourceIdentifier devOpsProjectResourceId = DevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, securityConnectorName, orgName, projectName);
            DevOpsProjectResource devOpsProject = client.GetDevOpsProjectResource(devOpsProjectResourceId);

            // get the collection of this DevOpsRepositoryResource
            DevOpsRepositoryCollection collection = devOpsProject.GetDevOpsRepositories();

            // invoke the operation
            string repoName = "myAzDevOpsRepo";
            DevOpsRepositoryData data = new DevOpsRepositoryData()
            {
                Properties = new DevOpsRepositoryProperties()
                {
                    OnboardingState = ResourceOnboardingState.NotApplicable,
                    ActionableRemediation = new ActionableRemediation()
                    {
                        State = ActionableRemediationState.Enabled,
                    },
                },
            };
            ArmOperation<DevOpsRepositoryResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, repoName, data);
            DevOpsRepositoryResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevOpsRepositoryData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
