// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_DefenderForStorageSettingResource
    {
        // Gets the Defender for Storage settings for the specified resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheDefenderForStorageSettingsForTheSpecifiedResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2022-12-01-preview/examples/DefenderForStorage/GetDefenderForStorageSettings_example.json
            // this example is just showing the usage of "DefenderForStorage_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DefenderForStorageSettingResource created on azure
            // for more information of creating DefenderForStorageSettingResource, please refer to the document of DefenderForStorageSettingResource
            string resourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount";
            DefenderForStorageSettingName settingName = DefenderForStorageSettingName.Current;
            ResourceIdentifier defenderForStorageSettingResourceId = DefenderForStorageSettingResource.CreateResourceIdentifier(resourceId, settingName);
            DefenderForStorageSettingResource defenderForStorageSetting = client.GetDefenderForStorageSettingResource(defenderForStorageSettingResourceId);

            // invoke the operation
            DefenderForStorageSettingName settingName0 = DefenderForStorageSettingName.Current;
            DefenderForStorageSettingResource result = await defenderForStorageSetting.GetAsync(settingName0);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DefenderForStorageSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates or updates the Defender for Storage settings on a specified resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesOrUpdatesTheDefenderForStorageSettingsOnASpecifiedResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/preview/2022-12-01-preview/examples/DefenderForStorage/PutDefenderForStorageSettings_example.json
            // this example is just showing the usage of "DefenderForStorage_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DefenderForStorageSettingResource created on azure
            // for more information of creating DefenderForStorageSettingResource, please refer to the document of DefenderForStorageSettingResource
            string resourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount";
            DefenderForStorageSettingName settingName = DefenderForStorageSettingName.Current;
            ResourceIdentifier defenderForStorageSettingResourceId = DefenderForStorageSettingResource.CreateResourceIdentifier(resourceId, settingName);
            DefenderForStorageSettingResource defenderForStorageSetting = client.GetDefenderForStorageSettingResource(defenderForStorageSettingResourceId);

            // invoke the operation
            DefenderForStorageSettingName settingName0 = DefenderForStorageSettingName.Current;
            DefenderForStorageSettingData data = new DefenderForStorageSettingData()
            {
                IsEnabled = true,
                IsOverrideSubscriptionLevelSettingsEnabled = true,
                IsSensitiveDataDiscoveryEnabled = true,
                ScanResultsEventGridTopicResourceId = new ResourceIdentifier("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.EventGrid/topics/sampletopic"),
                IsMalwareScanningOnUploadEnabled = true,
                CapGBPerMonth = -1,
            };
            ArmOperation<DefenderForStorageSettingResource> lro = await defenderForStorageSetting.UpdateAsync(WaitUntil.Completed, settingName0, data);
            DefenderForStorageSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DefenderForStorageSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
