// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_AdvancedThreatProtectionSettingResource
    {
        // Gets the Advanced Threat Protection settings for the specified resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheAdvancedThreatProtectionSettingsForTheSpecifiedResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2019-01-01/examples/AdvancedThreatProtection/GetAdvancedThreatProtectionSettings_example.json
            // this example is just showing the usage of "AdvancedThreatProtection_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AdvancedThreatProtectionSettingResource created on azure
            // for more information of creating AdvancedThreatProtectionSettingResource, please refer to the document of AdvancedThreatProtectionSettingResource
            string resourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount";
            ResourceIdentifier advancedThreatProtectionSettingResourceId = AdvancedThreatProtectionSettingResource.CreateResourceIdentifier(resourceId);
            AdvancedThreatProtectionSettingResource advancedThreatProtectionSetting = client.GetAdvancedThreatProtectionSettingResource(advancedThreatProtectionSettingResourceId);

            // invoke the operation
            AdvancedThreatProtectionSettingResource result = await advancedThreatProtectionSetting.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AdvancedThreatProtectionSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Creates or updates the Advanced Threat Protection settings on a specified resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreatesOrUpdatesTheAdvancedThreatProtectionSettingsOnASpecifiedResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2019-01-01/examples/AdvancedThreatProtection/PutAdvancedThreatProtectionSettings_example.json
            // this example is just showing the usage of "AdvancedThreatProtection_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AdvancedThreatProtectionSettingResource created on azure
            // for more information of creating AdvancedThreatProtectionSettingResource, please refer to the document of AdvancedThreatProtectionSettingResource
            string resourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount";
            ResourceIdentifier advancedThreatProtectionSettingResourceId = AdvancedThreatProtectionSettingResource.CreateResourceIdentifier(resourceId);
            AdvancedThreatProtectionSettingResource advancedThreatProtectionSetting = client.GetAdvancedThreatProtectionSettingResource(advancedThreatProtectionSettingResourceId);

            // invoke the operation
            AdvancedThreatProtectionSettingData data = new AdvancedThreatProtectionSettingData()
            {
                IsEnabled = true,
            };
            ArmOperation<AdvancedThreatProtectionSettingResource> lro = await advancedThreatProtectionSetting.CreateOrUpdateAsync(WaitUntil.Completed, data);
            AdvancedThreatProtectionSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AdvancedThreatProtectionSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
