// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_AdaptiveNetworkHardeningResource
    {
        // Get a single Adaptive Network Hardening resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASingleAdaptiveNetworkHardeningResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/AdaptiveNetworkHardenings/GetAdaptiveNetworkHardening_example.json
            // this example is just showing the usage of "AdaptiveNetworkHardenings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AdaptiveNetworkHardeningResource created on azure
            // for more information of creating AdaptiveNetworkHardeningResource, please refer to the document of AdaptiveNetworkHardeningResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            string adaptiveNetworkHardeningResourceName = "default";
            ResourceIdentifier adaptiveNetworkHardeningResourceId = AdaptiveNetworkHardeningResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName);
            AdaptiveNetworkHardeningResource adaptiveNetworkHardening = client.GetAdaptiveNetworkHardeningResource(adaptiveNetworkHardeningResourceId);

            // invoke the operation
            AdaptiveNetworkHardeningResource result = await adaptiveNetworkHardening.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AdaptiveNetworkHardeningData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Enforces the given rules on the NSG(s) listed in the request
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Enforce_EnforcesTheGivenRulesOnTheNSGSListedInTheRequest()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/AdaptiveNetworkHardenings/EnforceAdaptiveNetworkHardeningRules_example.json
            // this example is just showing the usage of "AdaptiveNetworkHardenings_Enforce" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AdaptiveNetworkHardeningResource created on azure
            // for more information of creating AdaptiveNetworkHardeningResource, please refer to the document of AdaptiveNetworkHardeningResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            string adaptiveNetworkHardeningResourceName = "default";
            ResourceIdentifier adaptiveNetworkHardeningResourceId = AdaptiveNetworkHardeningResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceNamespace, resourceType, resourceName, adaptiveNetworkHardeningResourceName);
            AdaptiveNetworkHardeningResource adaptiveNetworkHardening = client.GetAdaptiveNetworkHardeningResource(adaptiveNetworkHardeningResourceId);

            // invoke the operation
            AdaptiveNetworkHardeningEnforceContent content = new AdaptiveNetworkHardeningEnforceContent(new RecommendedSecurityRule[]
            {
new RecommendedSecurityRule()
{
Name = "rule1",
Direction = SecurityTrafficDirection.Inbound,
DestinationPort = 3389,
Protocols =
{
SecurityTransportProtocol.Tcp
},
IPAddresses =
{
"100.10.1.1","200.20.2.2","81.199.3.0/24"
},
},new RecommendedSecurityRule()
{
Name = "rule2",
Direction = SecurityTrafficDirection.Inbound,
DestinationPort = 22,
Protocols =
{
SecurityTransportProtocol.Tcp
},
IPAddresses =
{
},
}
            }, new string[]
            {
"/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1","/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg2"
            });
            await adaptiveNetworkHardening.EnforceAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }
    }
}
