// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_AdaptiveNetworkHardeningCollection
    {
        // List Adaptive Network Hardenings resources of an extended resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAdaptiveNetworkHardeningsResourcesOfAnExtendedResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/AdaptiveNetworkHardenings/ListByExtendedResourceAdaptiveNetworkHardenings_example.json
            // this example is just showing the usage of "AdaptiveNetworkHardenings_ListByExtendedResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AdaptiveNetworkHardeningResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            AdaptiveNetworkHardeningCollection collection = resourceGroupResource.GetAdaptiveNetworkHardenings(resourceNamespace, resourceType, resourceName);

            // invoke the operation and iterate over the result
            await foreach (AdaptiveNetworkHardeningResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AdaptiveNetworkHardeningData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a single Adaptive Network Hardening resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASingleAdaptiveNetworkHardeningResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/AdaptiveNetworkHardenings/GetAdaptiveNetworkHardening_example.json
            // this example is just showing the usage of "AdaptiveNetworkHardenings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AdaptiveNetworkHardeningResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            AdaptiveNetworkHardeningCollection collection = resourceGroupResource.GetAdaptiveNetworkHardenings(resourceNamespace, resourceType, resourceName);

            // invoke the operation
            string adaptiveNetworkHardeningResourceName = "default";
            AdaptiveNetworkHardeningResource result = await collection.GetAsync(adaptiveNetworkHardeningResourceName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AdaptiveNetworkHardeningData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a single Adaptive Network Hardening resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetASingleAdaptiveNetworkHardeningResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/AdaptiveNetworkHardenings/GetAdaptiveNetworkHardening_example.json
            // this example is just showing the usage of "AdaptiveNetworkHardenings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AdaptiveNetworkHardeningResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            AdaptiveNetworkHardeningCollection collection = resourceGroupResource.GetAdaptiveNetworkHardenings(resourceNamespace, resourceType, resourceName);

            // invoke the operation
            string adaptiveNetworkHardeningResourceName = "default";
            bool result = await collection.ExistsAsync(adaptiveNetworkHardeningResourceName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a single Adaptive Network Hardening resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetASingleAdaptiveNetworkHardeningResource()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/AdaptiveNetworkHardenings/GetAdaptiveNetworkHardening_example.json
            // this example is just showing the usage of "AdaptiveNetworkHardenings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AdaptiveNetworkHardeningResource
            string resourceNamespace = "Microsoft.Compute";
            string resourceType = "virtualMachines";
            string resourceName = "vm1";
            AdaptiveNetworkHardeningCollection collection = resourceGroupResource.GetAdaptiveNetworkHardenings(resourceNamespace, resourceType, resourceName);

            // invoke the operation
            string adaptiveNetworkHardeningResourceName = "default";
            NullableResponse<AdaptiveNetworkHardeningResource> response = await collection.GetIfExistsAsync(adaptiveNetworkHardeningResourceName);
            AdaptiveNetworkHardeningResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AdaptiveNetworkHardeningData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
