// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter.Samples
{
    public partial class Sample_AdaptiveApplicationControlGroupResource
    {
        // Gets a list of application control groups of machines for the subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAdaptiveApplicationControlGroups_GetsAListOfApplicationControlGroupsOfMachinesForTheSubscription()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ApplicationWhitelistings/GetAdaptiveApplicationControlsSubscription_example.json
            // this example is just showing the usage of "AdaptiveApplicationControls_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            bool? includePathRecommendations = true;
            bool? summary = false;
            await foreach (AdaptiveApplicationControlGroupResource item in subscriptionResource.GetAdaptiveApplicationControlGroupsAsync(includePathRecommendations: includePathRecommendations, summary: summary))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AdaptiveApplicationControlGroupData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets a configured application control VM/server group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAConfiguredApplicationControlVMServerGroup()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ApplicationWhitelistings/GetAdaptiveApplicationControlsGroup_example.json
            // this example is just showing the usage of "AdaptiveApplicationControls_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AdaptiveApplicationControlGroupResource created on azure
            // for more information of creating AdaptiveApplicationControlGroupResource, please refer to the document of AdaptiveApplicationControlGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            AzureLocation ascLocation = new AzureLocation("centralus");
            string groupName = "ERELGROUP1";
            ResourceIdentifier adaptiveApplicationControlGroupResourceId = AdaptiveApplicationControlGroupResource.CreateResourceIdentifier(subscriptionId, ascLocation, groupName);
            AdaptiveApplicationControlGroupResource adaptiveApplicationControlGroup = client.GetAdaptiveApplicationControlGroupResource(adaptiveApplicationControlGroupResourceId);

            // invoke the operation
            AdaptiveApplicationControlGroupResource result = await adaptiveApplicationControlGroup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AdaptiveApplicationControlGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update an application control machine group by adding a new application
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAnApplicationControlMachineGroupByAddingANewApplication()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ApplicationWhitelistings/PutAdaptiveApplicationControls_example.json
            // this example is just showing the usage of "AdaptiveApplicationControls_Put" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AdaptiveApplicationControlGroupResource created on azure
            // for more information of creating AdaptiveApplicationControlGroupResource, please refer to the document of AdaptiveApplicationControlGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            AzureLocation ascLocation = new AzureLocation("centralus");
            string groupName = "ERELGROUP1";
            ResourceIdentifier adaptiveApplicationControlGroupResourceId = AdaptiveApplicationControlGroupResource.CreateResourceIdentifier(subscriptionId, ascLocation, groupName);
            AdaptiveApplicationControlGroupResource adaptiveApplicationControlGroup = client.GetAdaptiveApplicationControlGroupResource(adaptiveApplicationControlGroupResourceId);

            // invoke the operation
            AdaptiveApplicationControlGroupData data = new AdaptiveApplicationControlGroupData()
            {
                EnforcementMode = AdaptiveApplicationControlEnforcementMode.Audit,
                ProtectionMode = new SecurityCenterFileProtectionMode()
                {
                    Exe = AdaptiveApplicationControlEnforcementMode.Audit,
                    Msi = AdaptiveApplicationControlEnforcementMode.None,
                    Script = AdaptiveApplicationControlEnforcementMode.None,
                },
                VmRecommendations =
{
new VmRecommendation()
{
ConfigurationStatus = SecurityCenterConfigurationStatus.Configured,
RecommendationAction = RecommendationAction.Recommended,
ResourceId = new ResourceIdentifier("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/erelh-stable/providers/microsoft.compute/virtualmachines/erelh-16090"),
EnforcementSupport = SecurityCenterVmEnforcementSupportState.Supported,
},new VmRecommendation()
{
ConfigurationStatus = SecurityCenterConfigurationStatus.Configured,
RecommendationAction = RecommendationAction.Recommended,
ResourceId = new ResourceIdentifier("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/matanvs/providers/microsoft.compute/virtualmachines/matanvs19"),
EnforcementSupport = SecurityCenterVmEnforcementSupportState.Supported,
}
},
                PathRecommendations =
{
new PathRecommendation()
{
Path = "[Exe] O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US\\*\\*\\0.0.0.0",
Action = RecommendationAction.Recommended,
IotSecurityRecommendationType = new IotSecurityRecommendationType("PublisherSignature"),
PublisherInfo = new SecurityCenterPublisherInfo()
{
PublisherName = "O=MICROSOFT CORPORATION, L=REDMOND, S=WASHINGTON, C=US",
ProductName = "*",
BinaryName = "*",
Version = "0.0.0.0",
},
IsCommon = true,
UserSids =
{
"S-1-1-0"
},
Usernames =
{
new UserRecommendation()
{
Username = "Everyone",
RecommendationAction = RecommendationAction.Recommended,
}
},
FileType = PathRecommendationFileType.Exe,
ConfigurationStatus = SecurityCenterConfigurationStatus.Configured,
},new PathRecommendation()
{
Path = "%OSDRIVE%\\WINDOWSAZURE\\SECAGENT\\WASECAGENTPROV.EXE",
Action = RecommendationAction.Recommended,
IotSecurityRecommendationType = new IotSecurityRecommendationType("ProductSignature"),
PublisherInfo = new SecurityCenterPublisherInfo()
{
PublisherName = "CN=MICROSOFT AZURE DEPENDENCY CODE SIGN",
ProductName = "MICROSOFT® COREXT",
BinaryName = "*",
Version = "0.0.0.0",
},
IsCommon = true,
UserSids =
{
"S-1-1-0"
},
Usernames =
{
new UserRecommendation()
{
Username = "NT AUTHORITY\\SYSTEM",
RecommendationAction = RecommendationAction.Recommended,
}
},
FileType = PathRecommendationFileType.Exe,
ConfigurationStatus = SecurityCenterConfigurationStatus.Configured,
},new PathRecommendation()
{
Path = "%OSDRIVE%\\WINDOWSAZURE\\PACKAGES_201973_7415\\COLLECTGUESTLOGS.EXE",
Action = RecommendationAction.Recommended,
IotSecurityRecommendationType = new IotSecurityRecommendationType("PublisherSignature"),
PublisherInfo = new SecurityCenterPublisherInfo()
{
PublisherName = "CN=MICROSOFT AZURE DEPENDENCY CODE SIGN",
ProductName = "*",
BinaryName = "*",
Version = "0.0.0.0",
},
IsCommon = true,
UserSids =
{
"S-1-1-0"
},
Usernames =
{
new UserRecommendation()
{
Username = "NT AUTHORITY\\SYSTEM",
RecommendationAction = RecommendationAction.Recommended,
}
},
FileType = PathRecommendationFileType.Exe,
ConfigurationStatus = SecurityCenterConfigurationStatus.Configured,
},new PathRecommendation()
{
Path = "C:\\directory\\file.exe",
Action = RecommendationAction.Add,
IotSecurityRecommendationType = new IotSecurityRecommendationType("File"),
IsCommon = true,
}
},
            };
            ArmOperation<AdaptiveApplicationControlGroupResource> lro = await adaptiveApplicationControlGroup.UpdateAsync(WaitUntil.Completed, data);
            AdaptiveApplicationControlGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AdaptiveApplicationControlGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete an application control machine group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAnApplicationControlMachineGroup()
        {
            // Generated from example definition: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/ApplicationWhitelistings/DeleteAdaptiveApplicationControls_example.json
            // this example is just showing the usage of "AdaptiveApplicationControls_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AdaptiveApplicationControlGroupResource created on azure
            // for more information of creating AdaptiveApplicationControlGroupResource, please refer to the document of AdaptiveApplicationControlGroupResource
            string subscriptionId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23";
            AzureLocation ascLocation = new AzureLocation("centralus");
            string groupName = "GROUP1";
            ResourceIdentifier adaptiveApplicationControlGroupResourceId = AdaptiveApplicationControlGroupResource.CreateResourceIdentifier(subscriptionId, ascLocation, groupName);
            AdaptiveApplicationControlGroupResource adaptiveApplicationControlGroup = client.GetAdaptiveApplicationControlGroupResource(adaptiveApplicationControlGroupResourceId);

            // invoke the operation
            await adaptiveApplicationControlGroup.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
