// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> Specifies a user-defined vectorizer for generating the vector embedding of a query string. Integration of an external vectorizer is achieved using the custom Web API interface of a skillset. </summary>
    public partial class WebApiVectorizer : VectorSearchVectorizer
    {
        /// <summary> Initializes a new instance of <see cref="WebApiVectorizer"/>. </summary>
        /// <param name="vectorizerName"> The name to associate with this particular vectorization method. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vectorizerName"/> is null. </exception>
        public WebApiVectorizer(string vectorizerName) : base(vectorizerName)
        {
            Argument.AssertNotNull(vectorizerName, nameof(vectorizerName));

            Kind = VectorSearchVectorizerKind.CustomWebApi;
        }

        /// <summary> Initializes a new instance of <see cref="WebApiVectorizer"/>. </summary>
        /// <param name="vectorizerName"> The name to associate with this particular vectorization method. </param>
        /// <param name="kind"> The name of the kind of vectorization method being configured for use with vector search. </param>
        /// <param name="parameters"> Specifies the properties of the user-defined vectorizer. </param>
        internal WebApiVectorizer(string vectorizerName, VectorSearchVectorizerKind kind, WebApiVectorizerParameters parameters) : base(vectorizerName, kind)
        {
            Parameters = parameters;
            Kind = kind;
        }

        /// <summary> Specifies the properties of the user-defined vectorizer. </summary>
        public WebApiVectorizerParameters Parameters { get; set; }
    }
}
