// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Search.Documents.Models
{
    public partial class VectorsDebugInfo
    {
        internal static VectorsDebugInfo DeserializeVectorsDebugInfo(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            QueryResultDocumentSubscores subscores = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("subscores"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    subscores = QueryResultDocumentSubscores.DeserializeQueryResultDocumentSubscores(property.Value);
                    continue;
                }
            }
            return new VectorsDebugInfo(subscores);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static VectorsDebugInfo FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeVectorsDebugInfo(document.RootElement);
        }
    }
}
