// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Models
{
    /// <summary>
    /// The threshold used for vector queries.
    /// Please note <see cref="VectorThreshold"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="SearchScoreThreshold"/> and <see cref="VectorSimilarityThreshold"/>.
    /// </summary>
    public abstract partial class VectorThreshold
    {
        /// <summary> Initializes a new instance of <see cref="VectorThreshold"/>. </summary>
        protected VectorThreshold()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VectorThreshold"/>. </summary>
        /// <param name="kind"> The kind of threshold used to filter vector queries. </param>
        internal VectorThreshold(VectorThresholdKind kind)
        {
            Kind = kind;
        }

        /// <summary> The kind of threshold used to filter vector queries. </summary>
        internal VectorThresholdKind Kind { get; set; }
    }
}
