// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Search.Documents.Models
{
    /// <summary> The results of the vector query will be filtered based on the vector similarity metric. Note this is the canonical definition of similarity metric, not the 'distance' version. The threshold direction (larger or smaller) will be chosen automatically according to the metric used by the field. </summary>
    public partial class VectorSimilarityThreshold : VectorThreshold
    {
        /// <summary> Initializes a new instance of <see cref="VectorSimilarityThreshold"/>. </summary>
        /// <param name="value"> The threshold will filter based on the similarity metric value. Note this is the canonical definition of similarity metric, not the 'distance' version. The threshold direction (larger or smaller) will be chosen automatically according to the metric used by the field. </param>
        public VectorSimilarityThreshold(double value)
        {
            Value = value;
            Kind = VectorThresholdKind.VectorSimilarity;
        }

        /// <summary> Initializes a new instance of <see cref="VectorSimilarityThreshold"/>. </summary>
        /// <param name="kind"> The kind of threshold used to filter vector queries. </param>
        /// <param name="value"> The threshold will filter based on the similarity metric value. Note this is the canonical definition of similarity metric, not the 'distance' version. The threshold direction (larger or smaller) will be chosen automatically according to the metric used by the field. </param>
        internal VectorSimilarityThreshold(VectorThresholdKind kind, double value) : base(kind)
        {
            Value = value;
            Kind = kind;
        }

        /// <summary> The threshold will filter based on the similarity metric value. Note this is the canonical definition of similarity metric, not the 'distance' version. The threshold direction (larger or smaller) will be chosen automatically according to the metric used by the field. </summary>
        public double Value { get; set; }
    }
}
