// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary>
    /// Specifies the vectorization method to be used during query time.
    /// Please note <see cref="VectorSearchVectorizer"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AIServicesVisionVectorizer"/>, <see cref="AzureMachineLearningVectorizer"/>, <see cref="AzureOpenAIVectorizer"/> and <see cref="WebApiVectorizer"/>.
    /// </summary>
    public abstract partial class VectorSearchVectorizer
    {
        /// <summary> Initializes a new instance of <see cref="VectorSearchVectorizer"/>. </summary>
        /// <param name="vectorizerName"> The name to associate with this particular vectorization method. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vectorizerName"/> is null. </exception>
        protected VectorSearchVectorizer(string vectorizerName)
        {
            Argument.AssertNotNull(vectorizerName, nameof(vectorizerName));

            VectorizerName = vectorizerName;
        }

        /// <summary> Initializes a new instance of <see cref="VectorSearchVectorizer"/>. </summary>
        /// <param name="vectorizerName"> The name to associate with this particular vectorization method. </param>
        /// <param name="kind"> The name of the kind of vectorization method being configured for use with vector search. </param>
        internal VectorSearchVectorizer(string vectorizerName, VectorSearchVectorizerKind kind)
        {
            VectorizerName = vectorizerName;
            Kind = kind;
        }
        /// <summary> The name of the kind of vectorization method being configured for use with vector search. </summary>
        internal VectorSearchVectorizerKind Kind { get; set; }
    }
}
