// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> The quantized data type of compressed vector values. </summary>
    public readonly partial struct VectorSearchCompressionTarget : IEquatable<VectorSearchCompressionTarget>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VectorSearchCompressionTarget"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VectorSearchCompressionTarget(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Int8Value = "int8";

        /// <summary> int8. </summary>
        public static VectorSearchCompressionTarget Int8 { get; } = new VectorSearchCompressionTarget(Int8Value);
        /// <summary> Determines if two <see cref="VectorSearchCompressionTarget"/> values are the same. </summary>
        public static bool operator ==(VectorSearchCompressionTarget left, VectorSearchCompressionTarget right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VectorSearchCompressionTarget"/> values are not the same. </summary>
        public static bool operator !=(VectorSearchCompressionTarget left, VectorSearchCompressionTarget right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VectorSearchCompressionTarget"/>. </summary>
        public static implicit operator VectorSearchCompressionTarget(string value) => new VectorSearchCompressionTarget(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VectorSearchCompressionTarget other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VectorSearchCompressionTarget other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
