// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;
using Azure.Search.Documents.Models;

namespace Azure.Search.Documents.Indexes.Models
{
    public partial class VectorSearchCompression : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(CompressionName);
            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind.ToString());
            if (Optional.IsDefined(RerankWithOriginalVectors))
            {
                writer.WritePropertyName("rerankWithOriginalVectors"u8);
                writer.WriteBooleanValue(RerankWithOriginalVectors.Value);
            }
            if (Optional.IsDefined(DefaultOversampling))
            {
                if (DefaultOversampling != null)
                {
                    writer.WritePropertyName("defaultOversampling"u8);
                    writer.WriteNumberValue(DefaultOversampling.Value);
                }
                else
                {
                    writer.WriteNull("defaultOversampling");
                }
            }
            if (Optional.IsDefined(TruncationDimension))
            {
                if (TruncationDimension != null)
                {
                    writer.WritePropertyName("truncationDimension"u8);
                    writer.WriteNumberValue(TruncationDimension.Value);
                }
                else
                {
                    writer.WriteNull("truncationDimension");
                }
            }
            writer.WriteEndObject();
        }

        internal static VectorSearchCompression DeserializeVectorSearchCompression(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("kind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "binaryQuantization": return BinaryQuantizationCompression.DeserializeBinaryQuantizationCompression(element);
                    case "scalarQuantization": return ScalarQuantizationCompression.DeserializeScalarQuantizationCompression(element);
                }
            }
            return UnknownVectorSearchCompression.DeserializeUnknownVectorSearchCompression(element);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static VectorSearchCompression FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeVectorSearchCompression(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
