// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Search.Documents.Indexes.Models
{
    /// <summary> The algorithm used for indexing and querying. </summary>
    internal readonly partial struct VectorSearchAlgorithmKind : IEquatable<VectorSearchAlgorithmKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VectorSearchAlgorithmKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VectorSearchAlgorithmKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HnswValue = "hnsw";
        private const string ExhaustiveKnnValue = "exhaustiveKnn";

        /// <summary> HNSW (Hierarchical Navigable Small World), a type of approximate nearest neighbors algorithm. </summary>
        public static VectorSearchAlgorithmKind Hnsw { get; } = new VectorSearchAlgorithmKind(HnswValue);
        /// <summary> Exhaustive KNN algorithm which will perform brute-force search. </summary>
        public static VectorSearchAlgorithmKind ExhaustiveKnn { get; } = new VectorSearchAlgorithmKind(ExhaustiveKnnValue);
        /// <summary> Determines if two <see cref="VectorSearchAlgorithmKind"/> values are the same. </summary>
        public static bool operator ==(VectorSearchAlgorithmKind left, VectorSearchAlgorithmKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VectorSearchAlgorithmKind"/> values are not the same. </summary>
        public static bool operator !=(VectorSearchAlgorithmKind left, VectorSearchAlgorithmKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VectorSearchAlgorithmKind"/>. </summary>
        public static implicit operator VectorSearchAlgorithmKind(string value) => new VectorSearchAlgorithmKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VectorSearchAlgorithmKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VectorSearchAlgorithmKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
